/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.canvas;

import com.elixirtech.canvas.graph.RelCol;
import com.elixirtech.canvas.graph.RelType;
import com.elixirtech.canvas.graph.Relationship;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.SchemaItem;
import com.elixirtech.ensemble.canvas.DataFlowGO;
import com.elixirtech.ensemble.canvas.DerivedNode;
import com.elixirtech.ensemble.canvas.GOUtil;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.ensemble.canvas.InitialText;
import java.util.List;

public class DerivativeGO
extends InOutGO {
    public DerivativeGO() {
        this.m_Ins.add(new InOutGO.In(this, "base", 0.5));
        this.m_Outs.add(new InOutGO.Out(this, "data", 0.5));
        this.m_Text = InitialText.DerivativeGO();
    }

    public DataSchema getBaseSchema() {
        InOutGO.In in = this.getIn("base");
        List<DataFlowGO> list = this.getFlowGOs(in);
        if (list.size() == 1) {
            DataFlowGO dataFlowGO = list.get(0);
            return ((InOutGO)dataFlowGO.getStartGO()).getSchema();
        }
        return null;
    }

    @Override
    public void buildParameters(ArgumentMap argumentMap) {
        InOutGO.In in = this.getIn("base");
        List<DataFlowGO> list = this.getFlowGOs(in);
        if (list.size() == 1) {
            DataFlowGO dataFlowGO = list.get(0);
            dataFlowGO.buildParameters(argumentMap);
        }
        int n = this.getDerivativeCount();
        for (int i = 0; i < n; ++i) {
            DerivedNode derivedNode = this.getDerivative(i);
            argumentMap.extractParameters(derivedNode.getValue());
        }
    }

    public void removeAllDerivatives() {
        this.removeOutRelationships(RelType.Owns);
    }

    public void addDerivative(String string, DataType dataType, String string2, DataAttributes dataAttributes) {
        DerivedNode derivedNode = new DerivedNode(string, dataType, string2, dataAttributes);
        this.connectTo(derivedNode, RelType.Owns);
    }

    public int getDerivativeCount() {
        RelCol relCol = this.getOutRelCol(RelType.Owns);
        return relCol.getCount();
    }

    public DerivedNode getDerivative(int n) {
        RelCol relCol = this.getOutRelCol(RelType.Owns);
        Relationship relationship = relCol.getItem(n);
        return (DerivedNode)relationship.getDestination();
    }

    @Override
    public DataSchema getSchema() {
        DataSchema dataSchema = this.getBaseSchema();
        if (dataSchema == null) {
            return null;
        }
        SchemaBuilder schemaBuilder = new SchemaBuilder(dataSchema.isCaseSensitive());
        int n = dataSchema.getColumnCount();
        for (int i = 0; i < n; ++i) {
            SchemaItem schemaItem = new SchemaItem(dataSchema.getColumnName(i), dataSchema.getColumnType(i), dataSchema.getAttributes(i));
            schemaBuilder.add(schemaItem);
        }
        schemaBuilder.discard(GOUtil.getDiscardSet(this, "Derivative_Discard"));
        RelCol relCol = this.getOutRelCol(RelType.Owns);
        int n2 = relCol.getCount();
        for (int i = 0; i < n2; ++i) {
            Relationship relationship = relCol.getItem(i);
            DerivedNode derivedNode = (DerivedNode)relationship.getDestination();
            SchemaItem schemaItem = new SchemaItem(derivedNode.getName(), derivedNode.getType(), derivedNode.getAttributes());
            schemaBuilder.add(schemaItem);
        }
        DataSchema dataSchema2 = schemaBuilder.getSchema();
        dataSchema2.setDateFormat(dataSchema.getDateFormat());
        dataSchema2.setTimeFormat(dataSchema.getTimeFormat());
        dataSchema2.setTimestampFormat(dataSchema.getTimestampFormat());
        return dataSchema2;
    }
}

