/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.canvas;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.canvas.graph.RelCol;
import com.elixirtech.canvas.graph.RelType;
import com.elixirtech.canvas.graph.Relationship;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.SchemaItem;
import com.elixirtech.ensemble.canvas.DataFlowGO;
import com.elixirtech.ensemble.canvas.GOUtil;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.ensemble.canvas.InitialText;
import com.elixirtech.ensemble.canvas.JoinNode;
import java.util.List;
import java.util.Set;

public class JoinGO
extends InOutGO {
    public JoinGO() {
        InOutGO.In in = new InOutGO.In("primary", 0.2);
        in.setWidthToMatchLabel("secondary");
        this.m_Ins.add(in);
        this.m_Ins.add(new InOutGO.In("secondary", 0.8));
        this.m_Outs.add(new InOutGO.Out("data", 0.5));
        this.m_Text = InitialText.JoinGO();
        this.setUserProperty("Join_Crossed", false);
        this.setUserProperty("Join_ZeroSecondary", "Keep");
        this.setUserProperty("Join_MultipleSecondary", "Repeat");
        this.setUserProperty("Join_PrimaryPrefix", "");
        this.setUserProperty("Join_SecondaryPrefix", "");
    }

    public DataSchema getPrimarySchema() {
        InOutGO.In in = this.getIn("primary");
        List<DataFlowGO> list = this.getFlowGOs(in);
        if (list.size() == 1) {
            DataFlowGO dataFlowGO = list.get(0);
            return ((InOutGO)dataFlowGO.getStartGO()).getSchema();
        }
        return null;
    }

    public DataSchema getSecondarySchema() {
        InOutGO.In in = this.getIn("secondary");
        List<DataFlowGO> list = this.getFlowGOs(in);
        if (list.size() == 1) {
            DataFlowGO dataFlowGO = list.get(0);
            return ((InOutGO)dataFlowGO.getStartGO()).getSchema();
        }
        return null;
    }

    @Override
    public void buildParameters(ArgumentMap argumentMap) {
        DataFlowGO dataFlowGO;
        InOutGO.In in = this.getIn("primary");
        List<DataFlowGO> list = this.getFlowGOs(in);
        if (list.size() == 1) {
            dataFlowGO = list.get(0);
            dataFlowGO.buildParameters(argumentMap);
        }
        if ((list = this.getFlowGOs(in = this.getIn("secondary"))).size() == 1) {
            dataFlowGO = list.get(0);
            dataFlowGO.buildParameters(argumentMap);
        }
    }

    public int getJoinCount() {
        RelCol relCol = this.getOutRelCol(RelType.Owns);
        return relCol.getCount();
    }

    public JoinNode getJoin(int n) {
        RelCol relCol = this.getOutRelCol(RelType.Owns);
        Relationship relationship = relCol.getItem(n);
        return (JoinNode)relationship.getDestination();
    }

    public boolean isCrossedJoin() {
        return this.isUserProperty("Join_Crossed");
    }

    @Override
    public DataSchema getSchema() {
        DataType dataType;
        Object object;
        int n;
        DataSchema dataSchema = this.getPrimarySchema();
        DataSchema dataSchema2 = this.getSecondarySchema();
        if (dataSchema == null || dataSchema2 == null) {
            return null;
        }
        String string = this.getUserProperty("Join_PrimaryPrefix");
        String string2 = this.getUserProperty("Join_SecondaryPrefix");
        Set<String> set = GOUtil.getDiscardSet(this, "Join_PrimaryDiscard");
        Set<String> set2 = GOUtil.getDiscardSet(this, "Join_SecondaryDiscard");
        SchemaBuilder schemaBuilder = new SchemaBuilder(dataSchema.isCaseSensitive());
        int n2 = dataSchema.getColumnCount();
        for (n = 0; n < n2; ++n) {
            object = dataSchema.getColumnName(n);
            dataType = dataSchema.getColumnType(n);
            if (set.contains(object)) continue;
            if (StringUtil.notEmpty(string)) {
                object = string.trim() + (String)object;
            }
            SchemaItem schemaItem = new SchemaItem((String)object, dataType);
            schemaBuilder.add(schemaItem);
        }
        n2 = dataSchema2.getColumnCount();
        for (n = 0; n < n2; ++n) {
            object = dataSchema2.getColumnName(n);
            dataType = dataSchema2.getColumnType(n);
            if (set2.contains(object)) continue;
            if (StringUtil.notEmpty(string2)) {
                object = string2.trim() + (String)object;
            }
            schemaBuilder.add(new SchemaItem((String)object, dataType));
        }
        return schemaBuilder.getSchema();
    }
}

