/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint;

import com.elixirtech.glint.Color;
import com.elixirtech.glint.Font;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.Image;
import com.elixirtech.glint.Pen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractGlint
implements IGlint {
    protected final Map<String, IGlint.FontId> m_FontMap = new HashMap<String, IGlint.FontId>();
    protected final Map<String, IGlint.ColorId> m_ColorMap = new HashMap<String, IGlint.ColorId>();
    protected final Map<Object, IGlint.ImageId> m_ImageMap = new HashMap<Object, IGlint.ImageId>();
    protected final Map<String, IGlint.PenId> m_PenMap = new HashMap<String, IGlint.PenId>();
    protected final List<Font> m_FontList = new ArrayList<Font>();
    protected final List<Color> m_ColorList = new ArrayList<Color>();
    protected final List<Image> m_ImageList = new ArrayList<Image>();
    protected final List<Pen> m_PenList = new ArrayList<Pen>();
    protected final List<String> m_StringList = new ArrayList<String>();

    public AbstractGlint() {
        this.defineColor(Color.NONE);
        this.definePen(Pen.NONE);
    }

    @Override
    public IGlint.FontId defineFont(Font font) {
        String string = this.getKey(font);
        IGlint.FontId fontId = this.m_FontMap.get(string);
        if (fontId == null) {
            fontId = new IGlint.FontId(this.m_FontList.size());
            this.m_FontMap.put(string, fontId);
            this.m_FontList.add(font);
        }
        return fontId;
    }

    @Override
    public final IGlint.ColorId defineColor(Color color) {
        String string = this.getKey(color);
        IGlint.ColorId colorId = this.m_ColorMap.get(string);
        if (colorId == null) {
            colorId = new IGlint.ColorId(this.m_ColorList.size());
            this.m_ColorMap.put(string, colorId);
            this.m_ColorList.add(color);
        }
        return colorId;
    }

    @Override
    public IGlint.ImageId defineImage(Image image) {
        IGlint.ImageId imageId = this.m_ImageMap.get(image);
        if (imageId == null) {
            imageId = new IGlint.ImageId(this.m_ImageList.size());
            String string = image.getId();
            if (string != null) {
                this.m_ImageMap.put(string, imageId);
            } else {
                this.m_ImageMap.put(image, imageId);
            }
            this.m_ImageList.add(image);
        }
        return imageId;
    }

    @Override
    public final IGlint.PenId definePen(Pen pen) {
        String string = this.getKey(pen);
        IGlint.PenId penId = this.m_PenMap.get(string);
        if (penId == null) {
            penId = new IGlint.PenId(this.m_PenList.size());
            this.m_PenMap.put(string, penId);
            this.m_PenList.add(pen);
        }
        return penId;
    }

    @Override
    public IGlint.StringId defineString() {
        IGlint.StringId stringId = new IGlint.StringId(this.m_StringList.size());
        this.m_StringList.add("");
        return stringId;
    }

    @Override
    public void setString(IGlint.StringId stringId, String string) {
        this.m_StringList.set(stringId.id, string);
    }

    @Override
    public Font getFont(IGlint.FontId fontId) {
        return this.m_FontList.get(fontId.id);
    }

    @Override
    public Color getColor(IGlint.ColorId colorId) {
        return this.m_ColorList.get(colorId.id);
    }

    @Override
    public Image getImage(IGlint.ImageId imageId) {
        return this.m_ImageList.get(imageId.id);
    }

    @Override
    public Pen getPen(IGlint.PenId penId) {
        return this.m_PenList.get(penId.id);
    }

    @Override
    public String getString(IGlint.StringId stringId) {
        return this.m_StringList.get(stringId.id);
    }

    public int getFontCount() {
        return this.m_FontList.size();
    }

    public int getImageCount() {
        return this.m_ImageList.size();
    }

    public int getColorCount() {
        return this.m_ColorList.size();
    }

    public int getPenCount() {
        return this.m_PenList.size();
    }

    @Override
    public void offsetOrigin(int n, int n2) {
    }

    @Override
    public void setOrigin(int n, int n2) {
    }

    @Override
    public void drawLine(IGlint.PenId penId, int n, int n2, int n3, int n4) {
    }

    @Override
    public void drawPolyline(IGlint.PenId penId, int[] nArray, int[] nArray2) {
    }

    @Override
    public void drawRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4) {
    }

    @Override
    public void drawRoundRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public void drawEllipse(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4) {
    }

    @Override
    public void drawPolygon(IGlint.PenId penId, IGlint.ColorId colorId, int[] nArray, int[] nArray2) {
    }

    @Override
    public void drawImage(IGlint.ImageId imageId, int n, int n2) {
    }

    @Override
    public void drawScaledImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4) {
    }

    @Override
    public void drawSubImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public void drawScaledSubImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
    }

    @Override
    public void drawText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, String string) {
    }

    @Override
    public void drawRotatedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, String string) {
    }

    private String getKey(Font font) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(font.getName());
        stringBuffer.append('|');
        stringBuffer.append(font.getSize());
        stringBuffer.append('|');
        stringBuffer.append(font.getStyle());
        return stringBuffer.toString();
    }

    private String getKey(Color color) {
        if (color == Color.NONE) {
            return "None";
        }
        return Integer.toString(color.getRGB());
    }

    private String getKey(Pen pen) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(pen.getColor().getRGB());
        stringBuffer.append('|');
        stringBuffer.append(pen.getWidth());
        stringBuffer.append('|');
        stringBuffer.append(pen.getStyle());
        return stringBuffer.toString();
    }
}

