/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint;

import com.elixirtech.glint.EyeConstants;
import com.elixirtech.glint.GlintException;
import com.elixirtech.glint.GlintInput;
import com.elixirtech.glint.IEye;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.PrintAttributes;
import com.elixirtech.glint.TOC;
import com.elixirtech.glint.TickReader;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class EyeReader
implements IEye,
EyeConstants {
    private Header m_Header;
    private final List<Chunk> m_Resources = new ArrayList<Chunk>();
    private final List<Chunk> m_Pages = new ArrayList<Chunk>();
    private TOC m_Tick;
    private PrintAttributes m_PrintAttributes;

    public static String getCaption(File file) throws IOException {
        try (FileInputStream fileInputStream = null;){
            int n;
            fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            EyeReader.readGlintVersion(dataInputStream);
            while ((n = dataInputStream.read()) != 0) {
                Chunk chunk = new Chunk(n);
                chunk.read(dataInputStream);
                switch (chunk.type) {
                    case 4: {
                        Header header = EyeReader.readHeader(chunk);
                        String string = header.name;
                        return string;
                    }
                }
            }
            throw new IOException("EyeReader didn't find a header in " + file.getAbsolutePath());
        }
    }

    public static int getPageCount(InputStream inputStream) throws IOException {
        int n;
        int n2 = 0;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        EyeReader.readGlintVersion(dataInputStream);
        while ((n = dataInputStream.read()) != 0) {
            Chunk chunk = new Chunk(n);
            chunk.read(dataInputStream);
            switch (chunk.type) {
                case 1: {
                    ++n2;
                    break;
                }
            }
        }
        return n2;
    }

    public static PrintAttributes getPrintAttributes(InputStream inputStream) throws Exception {
        int n;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        EyeReader.readGlintVersion(dataInputStream);
        while ((n = dataInputStream.read()) != 0) {
            Chunk chunk = new Chunk(n);
            chunk.read(dataInputStream);
            switch (chunk.type) {
                case 5: {
                    return PrintAttributes.read(new ByteArrayInputStream(chunk.bytes));
                }
            }
        }
        return null;
    }

    public EyeReader(InputStream inputStream) throws IOException {
        this(new DataInputStream(inputStream));
    }

    public EyeReader(DataInput dataInput) throws IOException {
        int n;
        EyeReader.readGlintVersion(dataInput);
        while ((n = dataInput.readUnsignedByte()) != 0) {
            Chunk chunk = new Chunk(n);
            chunk.read(dataInput);
            switch (chunk.type) {
                case 4: {
                    this.m_Header = EyeReader.readHeader(chunk);
                    break;
                }
                case 1: {
                    this.m_Pages.add(chunk);
                    break;
                }
                case 2: {
                    this.m_Resources.add(chunk);
                    break;
                }
                case 3: {
                    this.m_Tick = TickReader.read(new ByteArrayInputStream(chunk.bytes));
                    break;
                }
                case 5: {
                    this.m_PrintAttributes = PrintAttributes.read(new ByteArrayInputStream(chunk.bytes));
                    break;
                }
            }
        }
        this.buildDimensions();
    }

    @Override
    public int getWidth() {
        return this.m_Header.width;
    }

    @Override
    public int getHeight() {
        return this.m_Header.height;
    }

    @Override
    public String getName() {
        return this.m_Header.name;
    }

    @Override
    public int getPageCount() {
        return this.m_Pages.size();
    }

    @Override
    public void getResources(IGlint iGlint) {
        for (Chunk chunk : this.m_Resources) {
            GlintInput.read(new ByteArrayInputStream(chunk.bytes), false, iGlint);
        }
    }

    @Override
    public int getResourceCount() {
        return this.m_Resources.size();
    }

    @Override
    public byte[] getResources(int n) {
        return this.m_Resources.get((int)n).bytes;
    }

    @Override
    public void getPage(int n, IGlint iGlint) {
        if (n == 0 || n > this.m_Pages.size()) {
            throw new IllegalArgumentException("Invalid page: " + n + " - page range is 1 to " + this.m_Pages.size());
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.m_Pages.get((int)(n - 1)).bytes);
        GlintInput.read(byteArrayInputStream, true, iGlint);
    }

    @Override
    public byte[] getPage(int n) {
        if (n == 0 || n > this.m_Pages.size()) {
            throw new IllegalArgumentException("Invalid page: " + n + " - page range is 1 to " + this.m_Pages.size());
        }
        return this.m_Pages.get((int)(n - 1)).bytes;
    }

    @Override
    public TOC getTick() {
        return this.m_Tick;
    }

    @Override
    public PrintAttributes getPrintAttributes() {
        return this.m_PrintAttributes;
    }

    @Override
    public IEye.PageSetup getPageSetup(int n) {
        Chunk chunk = this.m_Pages.get(n - 1);
        return GlintInput.getPageSetup(chunk.bytes);
    }

    protected static void readGlintVersion(DataInput dataInput) throws IOException {
        int n;
        int n2 = MARKER.length();
        for (n = 0; n < n2; ++n) {
            char c = (char)dataInput.readByte();
            if (c == MARKER.get(n)) continue;
            throw new GlintException("Error at marker " + n + ". Got " + c + "(" + c + ") expected " + (char)MARKER.get(n) + "(" + MARKER.get(n) + ")");
        }
        n = VERSION.length();
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        if (byArray[2] > VERSION.get(2)) {
            throw new GlintException("Unsupported version [" + byArray[0] + byArray[1] + "." + byArray[2] + byArray[3]);
        }
    }

    protected static Header readHeader(Chunk chunk) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(chunk.bytes);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        return new Header(dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.readUTF());
    }

    protected void buildDimensions() {
        int n = this.m_Header.width;
        int n2 = this.m_Header.height;
        for (Chunk chunk : this.m_Pages) {
            IEye.PageSetup pageSetup = GlintInput.getPageSetup(chunk.bytes);
            n = Math.max(n, pageSetup.width);
            n2 = Math.max(n2, pageSetup.height);
        }
        this.m_Header.width = n;
        this.m_Header.height = n2;
    }

    private static class Chunk {
        public final int type;
        public byte[] bytes;

        public Chunk(int n) {
            this.type = n;
        }

        public void read(DataInput dataInput) throws IOException {
            int n = dataInput.readInt();
            this.bytes = new byte[n];
            dataInput.readFully(this.bytes);
        }
    }

    protected static class Header {
        public final String name;
        public int width;
        public int height;

        public Header(int n, int n2, String string) {
            this.width = n;
            this.height = n2;
            this.name = string;
        }
    }
}

