/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint;

import com.elixirtech.glint.ConstBytes;
import java.awt.FontFormatException;
import java.awt.font.TextAttribute;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public abstract class Font {
    public static final int TYPE_AWT = 1;
    public static final int TYPE_EMBEDDED = 2;
    public static final int TYPE_DERIVED = 3;
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINED = 4;
    public static final int STYLE_STRIKETHROUGH = 8;
    protected java.awt.Font m_Font;
    protected String m_Name;
    protected int m_Style;
    protected int m_Size;
    protected static final Map<String, AWTFont> AWT_CACHE = new HashMap<String, AWTFont>();

    public static Font newInstance(java.awt.Font font) {
        return new AWTFont(font);
    }

    public static Font newInstance(String string, int n, int n2) {
        return AWTFont.getInstance(string, n, n2);
    }

    public static Font newInstance(URL uRL, int n, int n2) throws MalformedURLException, IOException {
        int n3;
        byte[] byArray = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = uRL.openStream();
        while ((n3 = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n3);
        }
        return Font.newInstance(uRL.toString(), byteArrayOutputStream.toByteArray(), n, n2);
    }

    public static Font newInstance(String string, byte[] byArray, int n, int n2) throws IOException {
        try {
            return new ByteFont(string, byArray, n, n2);
        }
        catch (FontFormatException fontFormatException) {
            throw new IOException("FontFormatException: " + String.valueOf(fontFormatException));
        }
    }

    public static Font newInstance(Font font, int n, int n2) {
        return new DerivedFont(font, n, n2);
    }

    public abstract int getType();

    public String getName() {
        return this.m_Name;
    }

    public int getStyle() {
        return this.m_Style;
    }

    public boolean isUnderlined() {
        return (this.m_Style & 4) != 0;
    }

    public boolean isStrikethrough() {
        return (this.m_Style & 8) != 0;
    }

    public boolean isBold() {
        return (this.m_Style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.m_Style & 2) != 0;
    }

    public int getSize() {
        return this.m_Size;
    }

    public java.awt.Font getAWTFont() {
        return this.m_Font;
    }

    public static class AWTFont
    extends Font {
        public static AWTFont getInstance(String string, int n, int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append('-');
            stringBuilder.append(n);
            stringBuilder.append('-');
            stringBuilder.append(n2);
            String string2 = stringBuilder.toString();
            AWTFont aWTFont = (AWTFont)AWT_CACHE.get(string2);
            if (aWTFont == null) {
                aWTFont = new AWTFont(string, n, n2);
                AWT_CACHE.put(string2, aWTFont);
            }
            return aWTFont;
        }

        private AWTFont(String string, int n, int n2) {
            this.m_Name = string;
            this.m_Style = n;
            this.m_Size = n2;
            HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
            hashMap.put(TextAttribute.FAMILY, this.m_Name);
            hashMap.put(TextAttribute.SIZE, Float.valueOf((float)this.m_Size / 20.0f));
            hashMap.put(TextAttribute.WEIGHT, (n & 1) != 0 ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
            hashMap.put(TextAttribute.POSTURE, (n & 2) != 0 ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
            this.m_Font = new java.awt.Font(hashMap);
        }

        public AWTFont(java.awt.Font font) {
            this.m_Name = font.getName();
            int n = font.getStyle();
            if ((n & 1) != 0) {
                this.m_Style |= 1;
            }
            if ((n & 2) != 0) {
                this.m_Style |= 2;
            }
            this.m_Size = font.getSize() * 20;
            this.m_Font = font;
        }

        @Override
        public int getType() {
            return 1;
        }
    }

    public static class ByteFont
    extends Font {
        private final ConstBytes m_Bytes;

        public ByteFont(String string, byte[] byArray, int n, int n2) throws FontFormatException, IOException {
            this.m_Name = string;
            this.m_Bytes = new ConstBytes(byArray);
            this.m_Style = n;
            this.m_Size = n2;
            HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
            hashMap.put(TextAttribute.FAMILY, this.m_Name);
            hashMap.put(TextAttribute.SIZE, Float.valueOf((float)this.m_Size / 20.0f));
            hashMap.put(TextAttribute.WEIGHT, (n & 1) != 0 ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
            hashMap.put(TextAttribute.POSTURE, (n & 2) != 0 ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
            this.m_Font = new java.awt.Font(hashMap);
        }

        @Override
        public int getType() {
            return 2;
        }

        public ConstBytes getBytes() {
            return this.m_Bytes;
        }
    }

    public static class DerivedFont
    extends Font {
        private final Font m_Base;

        public DerivedFont(Font font, int n, int n2) {
            this.m_Base = font;
            this.m_Name = font.getName();
            this.m_Style = n;
            this.m_Size = n2;
            HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
            hashMap.put(TextAttribute.FAMILY, this.m_Name);
            hashMap.put(TextAttribute.SIZE, Float.valueOf((float)this.m_Size / 20.0f));
            hashMap.put(TextAttribute.WEIGHT, (n & 1) != 0 ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
            hashMap.put(TextAttribute.POSTURE, (n & 2) != 0 ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
            this.m_Font = new java.awt.Font(hashMap);
        }

        @Override
        public int getType() {
            return 3;
        }

        public Font getBase() {
            return this.m_Base;
        }
    }
}

