/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class TOC {
    public static final int START = 126;
    public static final int END = 127;
    private TOC m_Parent;
    private String m_Title;
    private int m_PageNo;
    private int m_Left;
    private int m_Top;
    private List<TOC> m_Children;

    public TOC() {
        this.m_Title = "";
    }

    public TOC(TOC tOC, String string, int n, int n2, int n3) {
        this.m_Parent = tOC;
        this.m_Title = string;
        this.m_PageNo = n;
        this.m_Left = n2;
        this.m_Top = n3;
        if (this.m_Parent != null) {
            this.m_Parent.addChild(this);
        }
    }

    public String toString() {
        return this.m_Title;
    }

    public void addChild(TOC tOC) {
        if (this.m_Children == null) {
            this.m_Children = new ArrayList<TOC>();
        }
        this.m_Children.add(tOC);
    }

    public TOC getParent() {
        return this.m_Parent;
    }

    public Iterator<TOC> getChildIterator() {
        if (this.m_Children != null) {
            return this.m_Children.iterator();
        }
        return new NullIterator();
    }

    public int getChildCount() {
        if (this.m_Children == null) {
            return 0;
        }
        return this.m_Children.size();
    }

    public String getTitle() {
        return this.m_Title;
    }

    public int getPageNo() {
        return this.m_PageNo;
    }

    public int getLeft() {
        return this.m_Left;
    }

    public int getTop() {
        return this.m_Top;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(126);
        dataOutputStream.writeUTF(this.m_Title);
        dataOutputStream.writeInt(this.m_PageNo);
        dataOutputStream.writeInt(this.m_Left);
        dataOutputStream.writeInt(this.m_Top);
        dataOutputStream.writeInt(this.getChildCount());
        Iterator<TOC> iterator = this.getChildIterator();
        while (iterator.hasNext()) {
            iterator.next().write(dataOutputStream);
        }
        dataOutputStream.write(127);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream.read() != 126) {
            throw new IOException("Bad start marker");
        }
        this.m_Title = dataInputStream.readUTF();
        this.m_PageNo = dataInputStream.readInt();
        this.m_Left = dataInputStream.readInt();
        this.m_Top = dataInputStream.readInt();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            TOC tOC = new TOC();
            tOC.read(dataInputStream);
            tOC.m_Parent = this;
            this.addChild(tOC);
        }
        if (dataInputStream.read() != 127) {
            throw new IOException("Bad end marker");
        }
    }

    private static class NullIterator
    implements Iterator<TOC> {
        private NullIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public TOC next() throws NoSuchElementException {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
        }
    }
}

