/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint.g2d;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class URLMap {
    private final List<URLStruct> m_URLStructs = new ArrayList<URLStruct>();

    public void addURLStruct(URLStruct uRLStruct) {
        assert (uRLStruct != null);
        this.m_URLStructs.add(0, uRLStruct);
    }

    public URLStruct getURLStruct(Point point) {
        for (URLStruct uRLStruct : this.m_URLStructs) {
            if (!uRLStruct.isHit(point)) continue;
            return uRLStruct;
        }
        return null;
    }

    public void clear() {
        this.m_URLStructs.clear();
    }

    public Iterator<URLStruct> getStructIterator() {
        return this.m_URLStructs.iterator();
    }

    public static class URLStruct {
        private Rectangle m_BoundingRect;
        private final List<Shape> m_Shapes = new ArrayList<Shape>();
        private final String m_URL;
        private final String m_Description;

        public URLStruct(String string, String string2) {
            this.m_URL = string;
            this.m_Description = string2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("URLStruct[" + this.m_URL + "]");
            for (int i = 0; i < this.m_Shapes.size(); ++i) {
                stringBuffer.append(this.m_Shapes.get(i));
            }
            return stringBuffer.toString();
        }

        public String getURL() {
            return this.m_URL;
        }

        public String getDescription() {
            return this.m_Description;
        }

        public void addShape(Shape shape) {
            this.m_BoundingRect = this.m_BoundingRect == null ? shape.getBounds() : this.m_BoundingRect.union(shape.getBounds());
            this.m_Shapes.add(shape);
        }

        public boolean isHit(Point point) {
            if (this.m_BoundingRect != null && this.m_BoundingRect.contains(point)) {
                for (Shape shape : this.m_Shapes) {
                    if (!shape.contains(point)) continue;
                    return true;
                }
            }
            return false;
        }

        public void paint(Graphics2D graphics2D) {
            Iterator<Shape> iterator = this.m_Shapes.iterator();
            while (iterator.hasNext()) {
                graphics2D.fill(iterator.next());
            }
        }
    }
}

