/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint.print;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.glint.EyeReader;
import com.elixirtech.glint.IEye;
import com.elixirtech.glint.print.GlintPrintable;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.NumberUp;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.print.event.PrintJobListener;

public class GlintStreamPrinter {
    protected IEye m_Eye;
    private String[] m_TargetPrinters;
    private Dimension m_PhysicalPageSize;
    private static final Set<Class<? extends Attribute>> SUPPORTED_ATTRIBUTES = new HashSet<Class<? extends Attribute>>();

    public void setTargetPrinters(String[] stringArray) {
        this.m_TargetPrinters = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_TargetPrinters[i] = stringArray[i];
        }
    }

    public void setPhysicalPageSize(Dimension dimension) {
        this.m_PhysicalPageSize = dimension;
    }

    public void print(boolean bl, InputStream inputStream, PrintRequestAttributeSet printRequestAttributeSet, PrintJobListener printJobListener) throws IOException, PrintException, PrinterException {
        this.m_Eye = new EyeReader(inputStream);
        this.installGlintAttributes(printRequestAttributeSet);
        PrintService printService = null;
        DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
        if (bl) {
            HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            hashPrintRequestAttributeSet.addAll(printRequestAttributeSet);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = dimension.width / 2 - 200;
            int n2 = dimension.height / 2 - 200;
            PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(sERVICE_FORMATTED, null);
            printService = PrintServiceLookup.lookupDefaultPrintService();
            printService = this.ensureAvailable(printService, printServiceArray);
            printService = ServiceUI.printDialog(null, n, n2, printServiceArray, printService, sERVICE_FORMATTED, hashPrintRequestAttributeSet);
            if (printService == null) {
                return;
            }
            Attribute[] attributeArray = hashPrintRequestAttributeSet.toArray();
            for (int i = 0; i < attributeArray.length; ++i) {
                if (!this.isSupportedAttribute(attributeArray[i])) continue;
                printRequestAttributeSet.add(attributeArray[i]);
            }
        } else if (this.m_TargetPrinters != null && this.m_TargetPrinters.length > 0) {
            PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(sERVICE_FORMATTED, printRequestAttributeSet);
            for (int i = 0; i < this.m_TargetPrinters.length && (printService = GlintStreamPrinter.getNamedService(printServiceArray, this.m_TargetPrinters[i])) == null; ++i) {
            }
        } else {
            PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(sERVICE_FORMATTED, printRequestAttributeSet);
            printService = PrintServiceLookup.lookupDefaultPrintService();
            if ((printService = this.ensureAvailable(printService, printServiceArray)) == null && printServiceArray.length > 0) {
                printService = printServiceArray[0];
            }
        }
        if (printService == null) {
            throw new PrinterException("Can't locate a print service that matches the desired attributes");
        }
        this.printNonInteractive(printService, printRequestAttributeSet, printJobListener);
    }

    public void printNonInteractive(PrintService printService, InputStream inputStream, PrintRequestAttributeSet printRequestAttributeSet, PrintJobListener printJobListener) throws IOException, PrintException {
        this.m_Eye = new EyeReader(inputStream);
        this.installGlintAttributes(printRequestAttributeSet);
        this.printNonInteractive(printService, printRequestAttributeSet, printJobListener);
    }

    public void printNonInteractive(PrintService printService, IEye iEye, PrintRequestAttributeSet printRequestAttributeSet, PrintJobListener printJobListener) throws IOException, PrintException {
        this.m_Eye = iEye;
        this.installGlintAttributes(printRequestAttributeSet);
        this.printNonInteractive(printService, printRequestAttributeSet, printJobListener);
    }

    private void printNonInteractive(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet, PrintJobListener printJobListener) throws IOException, PrintException {
        GlintPrintable glintPrintable = new GlintPrintable(this.m_Eye);
        glintPrintable.setPhysicalPageSize(this.m_PhysicalPageSize);
        SimpleDoc simpleDoc = new SimpleDoc(glintPrintable, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        DocPrintJob docPrintJob = printService.createPrintJob();
        if (printJobListener != null) {
            docPrintJob.addPrintJobListener(printJobListener);
        }
        docPrintJob.print(simpleDoc, printRequestAttributeSet);
    }

    protected void installGlintAttributes(PrintRequestAttributeSet printRequestAttributeSet) {
        MediaSizeName mediaSizeName;
        String string = this.m_Eye.getName();
        if (StringUtil.notEmpty(string)) {
            printRequestAttributeSet.add(new JobName(string, null));
        }
        IEye.PageSetup pageSetup = this.m_Eye.getPageSetup(1);
        float f = pageSetup.width;
        float f2 = pageSetup.height;
        int n = pageSetup.orientation;
        if (n == 1) {
            if (!printRequestAttributeSet.containsKey(OrientationRequested.class)) {
                printRequestAttributeSet.add(OrientationRequested.PORTRAIT);
            }
        } else {
            if (!printRequestAttributeSet.containsKey(OrientationRequested.class)) {
                printRequestAttributeSet.add(OrientationRequested.LANDSCAPE);
            }
            f = pageSetup.height;
            f2 = pageSetup.width;
        }
        if (!printRequestAttributeSet.containsKey(Media.class) && (mediaSizeName = GlintStreamPrinter.getNameFromMediaSize(f, f2)) != null) {
            printRequestAttributeSet.add(mediaSizeName);
        }
        if (!printRequestAttributeSet.containsKey(PageRanges.class)) {
            printRequestAttributeSet.add(new PageRanges(1, this.m_Eye.getPageCount()));
        }
    }

    private PrintService ensureAvailable(PrintService printService, PrintService[] printServiceArray) {
        if (printService == null) {
            return null;
        }
        String string = printService.getName();
        for (int i = 0; i < printServiceArray.length; ++i) {
            if (!printServiceArray[i].getName().equals(string)) continue;
            return printService;
        }
        return null;
    }

    private boolean isSupportedAttribute(Attribute attribute) {
        for (Class<? extends Attribute> clazz : SUPPORTED_ATTRIBUTES) {
            if (!clazz.isInstance(attribute)) continue;
            return true;
        }
        return false;
    }

    private static MediaSizeName getNameFromMediaSize(float f, float f2) {
        float f3 = f * 25.4f / 1440.0f;
        float f4 = f2 * 25.4f / 1440.0f;
        MediaSizeName mediaSizeName = MediaSize.findMedia(f3, f4, 1000);
        return mediaSizeName;
    }

    private static PrintService getNamedService(PrintService[] printServiceArray, String string) {
        for (int i = 0; i < printServiceArray.length; ++i) {
            String string2 = printServiceArray[i].getName();
            if (!string2.equals(string)) continue;
            return printServiceArray[i];
        }
        return null;
    }

    static {
        SUPPORTED_ATTRIBUTES.add(Chromaticity.class);
        SUPPORTED_ATTRIBUTES.add(Copies.class);
        SUPPORTED_ATTRIBUTES.add(JobName.class);
        SUPPORTED_ATTRIBUTES.add(MediaTray.class);
        SUPPORTED_ATTRIBUTES.add(NumberUp.class);
        SUPPORTED_ATTRIBUTES.add(PageRanges.class);
        SUPPORTED_ATTRIBUTES.add(PrinterName.class);
        SUPPORTED_ATTRIBUTES.add(PrinterResolution.class);
        SUPPORTED_ATTRIBUTES.add(PrintQuality.class);
        SUPPORTED_ATTRIBUTES.add(SheetCollate.class);
        SUPPORTED_ATTRIBUTES.add(Sides.class);
    }
}

