/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint.xml;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.glint.Color;
import com.elixirtech.glint.Font;
import com.elixirtech.glint.GlintException;
import com.elixirtech.glint.GraphicsCodes;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.IResourceManager;
import com.elixirtech.glint.Image;
import com.elixirtech.glint.Pen;
import com.elixirtech.glint.xml.ResourceManagerXML;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class GlintOutputXML
implements IGlint,
GraphicsCodes {
    public static final String GLINT = "http://www.elixirtech.com/Glint";
    protected ContentHandler m_Handler;
    protected IResourceManager m_ResourceManager;
    protected int m_Width;
    protected int m_Height;
    protected int m_Orientation;
    protected int m_OriginX;
    protected int m_OriginY;

    public GlintOutputXML(ContentHandler contentHandler) {
        this.m_Handler = contentHandler;
        try {
            this.initResourceManager();
            this.m_Handler.startDocument();
            AttributesImpl attributesImpl = new AttributesImpl();
            this.startElement("glint", attributesImpl);
        }
        catch (SAXException sAXException) {
            throw new GlintException("GlintOutputXML constructor", sAXException);
        }
    }

    @Override
    public void init(int n, int n2, int n3) {
        this.m_Width = n;
        this.m_Height = n2;
        this.m_Orientation = n3;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "width", this.m_Width);
        this.setAttr(attributesImpl, "height", this.m_Height);
        this.setAttr(attributesImpl, "orientation", this.m_Orientation == 1 ? "portrait" : "landscape");
        this.startElement("init", attributesImpl);
        this.endElement("init");
    }

    public void initResourceManager() {
        this.m_ResourceManager = new ResourceManagerXML(this.m_Handler);
    }

    @Override
    public IGlint.FontId defineFont(Font font) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.startElement("font", attributesImpl);
        this.endElement("font");
        return this.m_ResourceManager.defineFont(font);
    }

    @Override
    public IGlint.ColorId defineColor(Color color) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.startElement("color", attributesImpl);
        this.endElement("color");
        return this.m_ResourceManager.defineColor(color);
    }

    @Override
    public IGlint.ImageId defineImage(Image image) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.startElement("image", attributesImpl);
        this.endElement("image");
        return this.m_ResourceManager.defineImage(image);
    }

    @Override
    public IGlint.PenId definePen(Pen pen) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.startElement("pen", attributesImpl);
        this.endElement("pen");
        return this.m_ResourceManager.definePen(pen);
    }

    @Override
    public IGlint.StringId defineString() {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.startElement("string", attributesImpl);
        this.endElement("string");
        return this.m_ResourceManager.defineString();
    }

    @Override
    public void setString(IGlint.StringId stringId, String string) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "value", string);
        this.startElement("set-string", attributesImpl);
        this.endElement("set-string");
    }

    @Override
    public Font getFont(IGlint.FontId fontId) {
        return this.m_ResourceManager.getFont(fontId);
    }

    @Override
    public Color getColor(IGlint.ColorId colorId) {
        return this.m_ResourceManager.getColor(colorId);
    }

    @Override
    public Image getImage(IGlint.ImageId imageId) {
        return this.m_ResourceManager.getImage(imageId);
    }

    @Override
    public Pen getPen(IGlint.PenId penId) {
        return this.m_ResourceManager.getPen(penId);
    }

    @Override
    public String getString(IGlint.StringId stringId) {
        return this.m_ResourceManager.getString(stringId);
    }

    @Override
    public int getWidth() {
        return this.m_Width;
    }

    @Override
    public int getHeight() {
        return this.m_Height;
    }

    @Override
    public int getOrientation() {
        return this.m_Orientation;
    }

    @Override
    public void offsetOrigin(int n, int n2) {
        this.m_OriginX += n;
        this.m_OriginY += n2;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "x", n);
        this.setAttr(attributesImpl, "y", n2);
        this.startElement("offset-origin", attributesImpl);
        this.endElement("offset-origin");
    }

    @Override
    public void setOrigin(int n, int n2) {
        this.m_OriginX = n;
        this.m_OriginY = n2;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "x", n);
        this.setAttr(attributesImpl, "y", n2);
        this.startElement("set-origin", attributesImpl);
        this.endElement("set-origin");
    }

    @Override
    public int getOriginX() {
        return this.m_OriginX;
    }

    @Override
    public int getOriginY() {
        return this.m_OriginY;
    }

    @Override
    public void setURL(String string, String string2) {
        AttributesImpl attributesImpl = new AttributesImpl();
        if (StringUtil.notEmpty(string2)) {
            this.setAttr(attributesImpl, "description", string2);
        }
        this.setAttr(attributesImpl, "href", string);
        this.startElement("url", attributesImpl);
    }

    @Override
    public void resetURL() {
        this.endElement("url");
    }

    @Override
    public void pushClip(int n, int n2, int n3, int n4) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "x", Integer.toString(n));
        this.setAttr(attributesImpl, "y", Integer.toString(n2));
        this.setAttr(attributesImpl, "width", Integer.toString(n3));
        this.setAttr(attributesImpl, "height", Integer.toString(n4));
        this.startElement("clip", attributesImpl);
    }

    @Override
    public void pushClip(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "x", Integer.toString(n));
        this.setAttr(attributesImpl, "y", Integer.toString(n2));
        this.setAttr(attributesImpl, "width", Integer.toString(n3));
        this.setAttr(attributesImpl, "height", Integer.toString(n4));
        this.setAttr(attributesImpl, "rx", Integer.toString(n4));
        this.setAttr(attributesImpl, "ry", Integer.toString(n4));
        this.setAttr(attributesImpl, "sides", Integer.toString(n4));
        this.startElement("clip", attributesImpl);
    }

    @Override
    public void popClip() {
        this.endElement("clip");
    }

    @Override
    public void drawLine(IGlint.PenId penId, int n, int n2, int n3, int n4) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "pen", penId.id);
        this.setAttr(attributesImpl, "x1", n);
        this.setAttr(attributesImpl, "y1", n2);
        this.setAttr(attributesImpl, "x2", n3);
        this.setAttr(attributesImpl, "y2", n4);
        this.startElement("line", attributesImpl);
        this.endElement("line");
    }

    @Override
    public void drawPolyline(IGlint.PenId penId, int[] nArray, int[] nArray2) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "pen", penId.id);
        this.startElement("polyline", attributesImpl);
        for (int i = 0; i < nArray.length; ++i) {
            attributesImpl = new AttributesImpl();
            this.setAttr(attributesImpl, "x", nArray[i]);
            this.setAttr(attributesImpl, "y", nArray2[i]);
            this.startElement("point", attributesImpl);
            this.endElement("point");
        }
        this.endElement("polyline");
    }

    @Override
    public void drawRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "pen", penId.id);
        this.setAttr(attributesImpl, "fill", colorId.id);
        this.setAttr(attributesImpl, "x", n);
        this.setAttr(attributesImpl, "y", n2);
        this.setAttr(attributesImpl, "width", n3);
        this.setAttr(attributesImpl, "height", n4);
        this.startElement("rect", attributesImpl);
        this.endElement("rect");
    }

    @Override
    public void drawCellRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "pen", penId.id);
        this.setAttr(attributesImpl, "fill", colorId.id);
        this.setAttr(attributesImpl, "x", n);
        this.setAttr(attributesImpl, "y", n2);
        this.setAttr(attributesImpl, "width", n3);
        this.setAttr(attributesImpl, "height", n4);
        this.setAttr(attributesImpl, "sides", n5);
        this.startElement("cell-rect", attributesImpl);
        this.endElement("cell-rect");
    }

    @Override
    public void drawRoundRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5, int n6) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "pen", penId.id);
        this.setAttr(attributesImpl, "fill", colorId.id);
        this.setAttr(attributesImpl, "x", n);
        this.setAttr(attributesImpl, "y", n2);
        this.setAttr(attributesImpl, "width", n3);
        this.setAttr(attributesImpl, "height", n4);
        this.setAttr(attributesImpl, "rx", n5);
        this.setAttr(attributesImpl, "ry", n6);
        this.startElement("round-rect", attributesImpl);
        this.endElement("round-rect");
    }

    @Override
    public void drawRoundCellRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "pen", penId.id);
        this.setAttr(attributesImpl, "fill", colorId.id);
        this.setAttr(attributesImpl, "x", n);
        this.setAttr(attributesImpl, "y", n2);
        this.setAttr(attributesImpl, "width", n3);
        this.setAttr(attributesImpl, "height", n4);
        this.setAttr(attributesImpl, "rx", n5);
        this.setAttr(attributesImpl, "ry", n6);
        this.setAttr(attributesImpl, "sides", n7);
        this.startElement("round-cell-rect", attributesImpl);
        this.endElement("round-cell-rect");
    }

    @Override
    public void drawEllipse(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "pen", penId.id);
        this.setAttr(attributesImpl, "fill", colorId.id);
        this.setAttr(attributesImpl, "x", n);
        this.setAttr(attributesImpl, "y", n2);
        this.setAttr(attributesImpl, "width", n3);
        this.setAttr(attributesImpl, "height", n4);
        this.startElement("ellipse", attributesImpl);
        this.endElement("ellipse");
    }

    @Override
    public void drawPolygon(IGlint.PenId penId, IGlint.ColorId colorId, int[] nArray, int[] nArray2) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "pen", penId.id);
        this.setAttr(attributesImpl, "fill", colorId.id);
        this.startElement("polygon", attributesImpl);
        for (int i = 0; i < nArray.length; ++i) {
            attributesImpl = new AttributesImpl();
            this.setAttr(attributesImpl, "x", nArray[i]);
            this.setAttr(attributesImpl, "y", nArray2[i]);
            this.startElement("point", attributesImpl);
            this.endElement("point");
        }
        this.endElement("polygon");
    }

    @Override
    public void drawImage(IGlint.ImageId imageId, int n, int n2) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "image", imageId.id);
        this.setAttr(attributesImpl, "x", n);
        this.setAttr(attributesImpl, "y", n2);
        this.startElement("image", attributesImpl);
        this.endElement("image");
    }

    @Override
    public void drawScaledImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "image", imageId.id);
        this.setAttr(attributesImpl, "x", n);
        this.setAttr(attributesImpl, "y", n2);
        this.setAttr(attributesImpl, "width", n3);
        this.setAttr(attributesImpl, "height", n4);
        this.startElement("scaled-image", attributesImpl);
        this.endElement("scaled-image");
    }

    @Override
    public void drawSubImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4, int n5, int n6) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "image", imageId.id);
        this.setAttr(attributesImpl, "x", n);
        this.setAttr(attributesImpl, "y", n2);
        this.setAttr(attributesImpl, "src-x", n3);
        this.setAttr(attributesImpl, "src-y", n4);
        this.setAttr(attributesImpl, "src-width", n5);
        this.setAttr(attributesImpl, "src-height", n6);
        this.startElement("scaled-image", attributesImpl);
        this.endElement("scaled-image");
    }

    @Override
    public void drawScaledSubImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "image", imageId.id);
        this.setAttr(attributesImpl, "dst-x", n);
        this.setAttr(attributesImpl, "dst-y", n2);
        this.setAttr(attributesImpl, "dst-width", n3);
        this.setAttr(attributesImpl, "dst-height", n4);
        this.setAttr(attributesImpl, "src-x", n5);
        this.setAttr(attributesImpl, "src-y", n6);
        this.setAttr(attributesImpl, "src-width", n7);
        this.setAttr(attributesImpl, "src-height", n8);
        this.startElement("scaled-image", attributesImpl);
        this.endElement("scaled-image");
    }

    @Override
    public void drawText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, String string) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "font", fontId.id);
        this.setAttr(attributesImpl, "color", colorId.id);
        this.setAttr(attributesImpl, "x", n);
        this.setAttr(attributesImpl, "y", n2);
        this.setAttr(attributesImpl, "align", this.getAlignString(n3));
        this.startElement("text", attributesImpl);
        try {
            this.m_Handler.characters(string.toCharArray(), 0, string.length());
        }
        catch (SAXException sAXException) {
            throw new GlintException("GlintOutputXML.characters (drawText)", sAXException);
        }
        this.endElement("text");
    }

    @Override
    public void drawJustifiedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, String string) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "font", fontId.id);
        this.setAttr(attributesImpl, "color", colorId.id);
        this.setAttr(attributesImpl, "x", n);
        this.setAttr(attributesImpl, "y", n2);
        this.setAttr(attributesImpl, "width", n3);
        this.startElement("justified-text", attributesImpl);
        try {
            this.m_Handler.characters(string.toCharArray(), 0, string.length());
        }
        catch (SAXException sAXException) {
            throw new GlintException("GlintOutputXML.characters (drawJustifiedText)", sAXException);
        }
        this.endElement("justified-text");
    }

    @Override
    public void drawRotatedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, String string) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "font", fontId.id);
        this.setAttr(attributesImpl, "color", colorId.id);
        this.setAttr(attributesImpl, "x", n);
        this.setAttr(attributesImpl, "y", n2);
        this.setAttr(attributesImpl, "align", this.getAlignString(n3));
        this.setAttr(attributesImpl, "angle", n4);
        this.startElement("text", attributesImpl);
        try {
            this.m_Handler.characters(string.toCharArray(), 0, string.length());
        }
        catch (SAXException sAXException) {
            throw new GlintException("GlintOutputXML.characters (drawRotatedText)", sAXException);
        }
        this.endElement("text");
    }

    @Override
    public void drawRotatedJustifiedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, String string) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "font", fontId.id);
        this.setAttr(attributesImpl, "color", colorId.id);
        this.setAttr(attributesImpl, "x", n);
        this.setAttr(attributesImpl, "y", n2);
        this.setAttr(attributesImpl, "width", n3);
        this.setAttr(attributesImpl, "angle", n4);
        this.startElement("justified-text", attributesImpl);
        try {
            this.m_Handler.characters(string.toCharArray(), 0, string.length());
        }
        catch (SAXException sAXException) {
            throw new GlintException("GlintOutputXML.characters (drawRotatedJustifiedText)", sAXException);
        }
        this.endElement("justified-text");
    }

    @Override
    public void drawRTF(int n, int n2, int n3, int n4, String string) {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.setAttr(attributesImpl, "x", n);
        this.setAttr(attributesImpl, "y", n2);
        this.setAttr(attributesImpl, "width", n3);
        this.setAttr(attributesImpl, "height", n4);
        this.startElement("rtf", attributesImpl);
        try {
            this.m_Handler.characters(string.toCharArray(), 0, string.length());
        }
        catch (SAXException sAXException) {
            throw new GlintException("GlintOutputXML.characters (drawRTF)", sAXException);
        }
        this.endElement("rtf");
    }

    @Override
    public void flush() {
        AttributesImpl attributesImpl = new AttributesImpl();
        this.startElement("flush", attributesImpl);
        this.endElement("flush");
    }

    public void close() {
        this.endElement("glint");
        try {
            this.m_Handler.endDocument();
        }
        catch (SAXException sAXException) {
            throw new GlintException("GlintOutputXML.endDocument", sAXException);
        }
    }

    private String getAlignString(int n) {
        if (n == 1) {
            return "left";
        }
        if (n == 2) {
            return "right";
        }
        if (n == 3) {
            return "center";
        }
        return "";
    }

    private void setAttr(AttributesImpl attributesImpl, String string, int n) {
        this.setAttr(attributesImpl, string, Integer.toString(n));
    }

    private void setAttr(AttributesImpl attributesImpl, String string, String string2) {
        attributesImpl.addAttribute("", string, string, "CDATA", string2);
    }

    private void startElement(String string, Attributes attributes) {
        try {
            this.m_Handler.startElement(GLINT, string, "gl:" + string, attributes);
        }
        catch (SAXException sAXException) {
            throw new GlintException("startElement(" + string + ")", sAXException);
        }
    }

    private void endElement(String string) {
        try {
            this.m_Handler.endElement(GLINT, string, "gl:" + string);
        }
        catch (SAXException sAXException) {
            throw new GlintException("endElement(" + string + ")", sAXException);
        }
    }
}

