/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.graphics;

import com.elixirtech.graphics.GStringCalculations;
import com.elixirtech.graphics.Orientation;
import com.elixirtech.graphics.TextAlignment;
import com.elixirtech.graphics.VerticalAlignment;
import com.elixirtech.graphics.font.Font;
import com.elixirtech.graphics.font.FontBox;
import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.graphics.font.IFontMeasurerFactory;
import com.elixirtech.graphics.font.RotatedGlyphRenderer;
import com.elixirtech.graphics.font.Span;
import com.elixirtech.graphics.font.SpanHolder;
import com.elixirtech.graphics.font.TextLine;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Iterator;

public class GString {
    IFontMeasurerFactory m_FontMeasurerFactory;
    String m_String;
    Rectangle m_Rectangle;
    boolean m_CanGrow;
    boolean m_CanShrink;
    Orientation m_BaselineOrientation = Orientation.ANGLE_0;
    Orientation m_GlyphOrientation = Orientation.ANGLE_0;
    TextAlignment m_Alignment = TextAlignment.LEFT;
    VerticalAlignment m_VAlignment = VerticalAlignment.TOP;
    SpanHolder m_SpanHolder = new SpanHolder();
    boolean m_Debug;
    private GStringCalculations m_Calculations;
    private static final double NINETY_DEGREES = Math.toRadians(90.0);

    public void setFontMeasurerFactory(IFontMeasurerFactory iFontMeasurerFactory) {
        this.m_FontMeasurerFactory = iFontMeasurerFactory;
        this.m_Calculations = null;
    }

    public void setString(String string) {
        this.m_String = string;
        this.m_Calculations = null;
    }

    public void addSpan(Span span) {
        this.m_SpanHolder.addSpan(span);
        this.m_Calculations = null;
    }

    public void setRect(Rectangle rectangle) {
        this.m_Rectangle = rectangle;
        this.m_Calculations = null;
    }

    public void setGrowable(boolean bl) {
        this.m_CanGrow = bl;
        this.m_Calculations = null;
    }

    public void setShrinkable(boolean bl) {
        this.m_CanShrink = bl;
        this.m_Calculations = null;
    }

    public void setBaselineOrientation(Orientation orientation) {
        this.m_BaselineOrientation = orientation;
        this.m_Calculations = null;
    }

    public void setGlyphOrientation(Orientation orientation) {
        this.m_GlyphOrientation = orientation;
        this.m_Calculations = null;
    }

    public void setTextAlignment(TextAlignment textAlignment) {
        this.m_Alignment = textAlignment;
        this.m_Calculations = null;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.m_VAlignment = verticalAlignment;
        this.m_Calculations = null;
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public IFontMeasurerFactory getFontMeasurerFactory() {
        return this.m_FontMeasurerFactory;
    }

    public Orientation getBaselineOrientation() {
        return this.m_BaselineOrientation;
    }

    public Orientation getGlyphOrientation() {
        return this.m_GlyphOrientation;
    }

    public void draw(Graphics2D graphics2D) {
        int n;
        if (this.m_Calculations == null) {
            this.buildCalculations();
        }
        int n2 = this.m_Calculations.getHeight();
        if (this.m_BaselineOrientation == Orientation.ANGLE_0) {
            n = 0;
            if (this.m_VAlignment == VerticalAlignment.BOTTOM) {
                n = this.m_Rectangle.height - n2;
            } else if (this.m_VAlignment == VerticalAlignment.CENTER) {
                n = (this.m_Rectangle.height - n2) / 2;
            }
            graphics2D.translate(this.m_Rectangle.x, this.m_Rectangle.y + n);
            this.drawLines(graphics2D);
            graphics2D.translate(-this.m_Rectangle.x, -this.m_Rectangle.y - n);
        } else if (this.m_BaselineOrientation == Orientation.ANGLE_180) {
            n = 0;
            if (this.m_VAlignment == VerticalAlignment.TOP) {
                n = this.m_Rectangle.height - n2;
            } else if (this.m_VAlignment == VerticalAlignment.CENTER) {
                n = (this.m_Rectangle.height - n2) / 2;
            }
            graphics2D.translate(this.m_Rectangle.x + this.m_Rectangle.width, this.m_Rectangle.y + n2 + n);
            graphics2D.scale(-1.0, -1.0);
            this.drawLines(graphics2D);
            graphics2D.scale(-1.0, -1.0);
            graphics2D.translate(-this.m_Rectangle.x - this.m_Rectangle.width, -this.m_Rectangle.y - n2 - n);
        }
        if (this.m_BaselineOrientation == Orientation.ANGLE_90) {
            n = 0;
            if (this.m_VAlignment == VerticalAlignment.BOTTOM) {
                n = this.m_Rectangle.width - n2;
            } else if (this.m_VAlignment == VerticalAlignment.CENTER) {
                n = (this.m_Rectangle.width - n2) / 2;
            }
            graphics2D.translate(this.m_Rectangle.x + this.m_Rectangle.width - n, this.m_Rectangle.y);
            graphics2D.rotate(NINETY_DEGREES);
            this.drawLines(graphics2D);
            graphics2D.rotate(-NINETY_DEGREES);
            graphics2D.translate(-this.m_Rectangle.x - this.m_Rectangle.width + n, -this.m_Rectangle.y);
        }
        if (this.m_BaselineOrientation == Orientation.ANGLE_270) {
            n = 0;
            if (this.m_VAlignment == VerticalAlignment.BOTTOM) {
                n = this.m_Rectangle.width - n2;
            } else if (this.m_VAlignment == VerticalAlignment.CENTER) {
                n = (this.m_Rectangle.width - n2) / 2;
            }
            graphics2D.translate(this.m_Rectangle.x + n, this.m_Rectangle.y + this.m_Rectangle.height);
            graphics2D.rotate(-NINETY_DEGREES);
            this.drawLines(graphics2D);
            graphics2D.rotate(NINETY_DEGREES);
            graphics2D.translate(-this.m_Rectangle.x - n, -this.m_Rectangle.y + this.m_Rectangle.height);
        }
    }

    protected void buildCalculations() {
        this.m_Calculations = new GStringCalculations(this);
    }

    protected void drawLines(Graphics2D graphics2D) {
        Iterator<TextLine> iterator = this.m_Calculations.getLines();
        while (iterator.hasNext()) {
            TextLine textLine = iterator.next();
            int n = textLine.getWidth();
            int n2 = 0;
            if (this.m_Alignment == TextAlignment.RIGHT) {
                n2 = this.m_Rectangle.width - n;
            } else if (this.m_Alignment == TextAlignment.CENTER) {
                n2 = (this.m_Rectangle.width - n) / 2;
            }
            int n3 = textLine.getY() + textLine.getBaseline();
            Iterator<FontBox> iterator2 = textLine.getBoxes();
            while (iterator2.hasNext()) {
                FontBox fontBox = iterator2.next();
                Rectangle rectangle = fontBox.getRectangle();
                if (this.m_Debug) {
                    graphics2D.setColor(Color.yellow);
                    graphics2D.drawRect(rectangle.x + n2, textLine.getY(), rectangle.width, textLine.getHeight());
                }
                Font font = fontBox.getFont();
                IFontMeasurer iFontMeasurer = this.m_FontMeasurerFactory.getInstance(font);
                graphics2D.setFont(Font.getAWTFont20(font));
                graphics2D.setColor(font.getColor());
                RotatedGlyphRenderer.draw(graphics2D, fontBox, rectangle.x + n2, n3, iFontMeasurer);
            }
        }
    }
}

