/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.graphics.util;

import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;

public class DoubleStroke
implements Stroke {
    private int m_Width;

    public DoubleStroke(int n) {
        this.m_Width = n;
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            int n = this.m_Width / 2;
            rectangle.x -= n;
            rectangle.y -= n;
            rectangle.width += this.m_Width;
            rectangle.height += this.m_Width;
            Area area = new Area(shape);
            int n2 = this.m_Width / 3;
            rectangle.x += n2;
            rectangle.y += n2;
            rectangle.width -= 2 * n2;
            rectangle.height -= 2 * n2;
            area.subtract(new Area(rectangle));
            rectangle.x += n2;
            rectangle.y += n2;
            rectangle.width -= 2 * n2;
            rectangle.height -= 2 * n2;
            area.add(new Area(rectangle));
            rectangle.x += n2;
            rectangle.y += n2;
            rectangle.width -= 2 * n2;
            rectangle.height -= 2 * n2;
            area.subtract(new Area(rectangle));
            return area;
        }
        BasicStroke basicStroke = new BasicStroke((float)this.m_Width - (float)this.m_Width / 3.0f);
        BasicStroke basicStroke2 = new BasicStroke((float)this.m_Width / 3.0f);
        Shape shape2 = basicStroke.createStrokedShape(shape);
        return basicStroke2.createStrokedShape(shape2);
    }
}

