/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.graphics.util;

import com.elixirtech.graphics.util.MunchTransform;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;

public class WaveStroke
implements Stroke {
    private static final float FLATNESS = 1.0f;
    private static final float DEFAULT_WAVE_LENGTH = 12.0f;
    private static final float DEFAULT_WAVE_AMPLITUDE = 4.0f;
    private static final float DEFAULT_WIDTH = 1.0f;
    private final float[] POSITIVE_PHASE_POINTS = new float[]{1.0f, 2.0f, 3.0f, 2.0f, 5.0f, 2.0f, 6.0f, 0.0f, 7.0f, -2.0f, 9.0f, -2.0f, 11.0f, -2.0f, 12.0f, 0.0f};
    private final float[] NEGATIVE_PHASE_POINTS = new float[]{1.0f, -2.0f, 3.0f, -2.0f, 5.0f, -2.0f, 6.0f, 0.0f, 7.0f, 2.0f, 9.0f, 2.0f, 11.0f, 2.0f, 12.0f, 0.0f};
    private float m_WaveLength = 12.0f;
    private float m_WaveAmplitude = 4.0f;
    private float m_Width = 1.0f;
    private BasicStroke m_BasicStroke;

    public WaveStroke(float f) {
        this(f, 12.0f, 4.0f);
    }

    public WaveStroke(float f, float f2, float f3) {
        if (f2 <= 0.0f || f3 <= 0.0f || f <= 0.0f) {
            throw new IllegalArgumentException("Arguments should be greater than zero");
        }
        this.m_BasicStroke = new BasicStroke(f, 0, 2);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToScale(f2 / 12.0f, f3 / 4.0f);
        affineTransform.transform(this.POSITIVE_PHASE_POINTS, 0, this.POSITIVE_PHASE_POINTS, 0, this.POSITIVE_PHASE_POINTS.length / 2);
        affineTransform.transform(this.NEGATIVE_PHASE_POINTS, 0, this.NEGATIVE_PHASE_POINTS, 0, this.NEGATIVE_PHASE_POINTS.length / 2);
        this.m_WaveLength = f2;
        this.m_WaveAmplitude = f3;
        this.m_Width = f;
    }

    public Shape createWavyOutline(Shape shape) {
        GeneralPath generalPath;
        MunchTransform munchTransform = new MunchTransform(1.0f);
        PathIterator pathIterator = munchTransform.transform(shape).getPathIterator(null, 1.0);
        float[] fArray = new float[6];
        int n = 0;
        AddSegmentControl addSegmentControl = new AddSegmentControl();
        addSegmentControl.s = generalPath = new GeneralPath();
        while (!pathIterator.isDone()) {
            n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    addSegmentControl.x = fArray[0];
                    addSegmentControl.y = fArray[1];
                    addSegmentControl.mx = addSegmentControl.x;
                    addSegmentControl.my = addSegmentControl.y;
                    addSegmentControl.start = true;
                    break;
                }
                case 1: {
                    addSegmentControl.dx = fArray[0];
                    addSegmentControl.dy = fArray[1];
                    addSegmentControl.isClose = addSegmentControl.dx == addSegmentControl.mx && addSegmentControl.dy == addSegmentControl.my;
                    this.addSegment(addSegmentControl);
                    addSegmentControl.start = false;
                    addSegmentControl.x = addSegmentControl.dx;
                    addSegmentControl.y = addSegmentControl.dy;
                    break;
                }
                case 4: {
                    addSegmentControl.isClose = true;
                    addSegmentControl.dx = addSegmentControl.mx;
                    addSegmentControl.dy = addSegmentControl.my;
                    this.addSegment(addSegmentControl);
                    addSegmentControl.start = false;
                    addSegmentControl.x = addSegmentControl.mx;
                    addSegmentControl.y = addSegmentControl.my;
                    break;
                }
                default: {
                    throw new RuntimeException("Illegal seg type : " + n);
                }
            }
            pathIterator.next();
        }
        return generalPath;
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        return this.m_BasicStroke.createStrokedShape(this.createWavyOutline(shape));
    }

    private void addSegment(AddSegmentControl addSegmentControl) {
        float f;
        float f2 = addSegmentControl.x;
        float f3 = addSegmentControl.y;
        float f4 = addSegmentControl.dx;
        float f5 = addSegmentControl.dy;
        GeneralPath generalPath = addSegmentControl.s;
        if (!addSegmentControl.start && addSegmentControl.startOverride) {
            f2 = addSegmentControl.startX;
            f3 = addSegmentControl.startY;
        }
        if (addSegmentControl.start) {
            addSegmentControl.s.moveTo(f2, f3);
        }
        float[] fArray = this.POSITIVE_PHASE_POINTS;
        if (addSegmentControl.negativePhase) {
            fArray = this.NEGATIVE_PHASE_POINTS;
        }
        if (f2 == f4 && f3 == f5) {
            return;
        }
        float f6 = (float)Point2D.distance(f2, f3, f4, f5);
        double d = Math.atan2(f5 - f3, f4 - f2);
        float f7 = f6 / this.m_WaveLength;
        int n = (int)Math.floor(f7);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToScale(1.0, 1.0);
        affineTransform.translate(f2, f3);
        float[] fArray2 = new float[fArray.length];
        affineTransform.rotate(d);
        if (n > 1 && (double)(f7 - (float)n) < 0.5) {
            f = f7 / (float)n;
            affineTransform.scale(f, 1.0);
            f7 = n;
        }
        affineTransform.transform(fArray, 0, fArray2, 0, fArray.length / 2);
        f = (f4 - f2) / f7;
        float f8 = (f5 - f3) / f7;
        int n2 = fArray2.length / 4;
        affineTransform.setToTranslation(f, f8);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                generalPath.quadTo(fArray2[4 * j], fArray2[4 * j + 1], fArray2[4 * j + 2], fArray2[4 * j + 3]);
            }
            affineTransform.transform(fArray2, 0, fArray2, 0, fArray2.length / 2);
        }
        if (addSegmentControl.isClose) {
            if ((double)(f7 - (float)n) > 0.75) {
                generalPath.quadTo(fArray2[0], fArray2[1], fArray2[2], fArray2[3]);
                generalPath.quadTo(fArray2[4], fArray2[5], fArray2[6], fArray2[7]);
                generalPath.quadTo(fArray2[8], fArray2[9], fArray2[10], fArray2[11]);
                generalPath.quadTo(fArray2[12], fArray2[13], f4, f5);
                addSegmentControl.startOverride = false;
            } else if ((double)(f7 - (float)n) > 0.25) {
                generalPath.quadTo(fArray2[0], fArray2[1], fArray2[2], fArray2[3]);
                generalPath.quadTo(fArray2[4], fArray2[5], f4, f5);
                addSegmentControl.negativePhase ^= true;
                addSegmentControl.startOverride = false;
            } else {
                generalPath.lineTo(f4, f5);
                addSegmentControl.startOverride = false;
            }
        } else if ((double)(f7 - (float)n) >= 0.5) {
            generalPath.quadTo(fArray2[0], fArray2[1], fArray2[2], fArray2[3]);
            generalPath.quadTo(fArray2[4], fArray2[5], fArray2[6], fArray2[7]);
            addSegmentControl.negativePhase ^= true;
            addSegmentControl.startOverride = true;
            addSegmentControl.startX = f2 + ((float)n + 0.5f) * f;
            addSegmentControl.startY = f3 + ((float)n + 0.5f) * f8;
        } else {
            addSegmentControl.startOverride = true;
            addSegmentControl.startX = f2 + (float)n * f;
            addSegmentControl.startY = f3 + (float)n * f8;
        }
    }

    public float getWidth() {
        return this.m_Width;
    }

    public float getWaveLength() {
        return this.m_WaveLength;
    }

    public float getWaveAmplitude() {
        return this.m_WaveAmplitude;
    }

    static class AddSegmentControl {
        public float x;
        public float y;
        public float dx;
        public float dy;
        public float mx;
        public float my;
        public float startX;
        public float startY;
        public GeneralPath s;
        public boolean start;
        public boolean negativePhase;
        public boolean startOverride;
        public boolean isClose;

        AddSegmentControl() {
        }
    }
}

