/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jdom;

import com.elixirtech.jdom.Attribute;
import com.elixirtech.jdom.AttributeList;
import com.elixirtech.jdom.CDATA;
import com.elixirtech.jdom.Comment;
import com.elixirtech.jdom.Content;
import com.elixirtech.jdom.ContentList;
import com.elixirtech.jdom.DescendantIterator;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.EntityRef;
import com.elixirtech.jdom.FilterIterator;
import com.elixirtech.jdom.IllegalAddException;
import com.elixirtech.jdom.Namespace;
import com.elixirtech.jdom.Parent;
import com.elixirtech.jdom.ProcessingInstruction;
import com.elixirtech.jdom.Text;
import com.elixirtech.jdom.Verifier;
import com.elixirtech.jdom.filter.ElementFilter;
import com.elixirtech.jdom.filter.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Element
extends Content
implements Parent {
    private static final int INITIAL_ARRAY_SIZE = 5;
    protected String m_Name;
    protected transient Namespace m_Namespace;
    protected transient List<Namespace> additionalNamespaces;
    AttributeList attributes = new AttributeList(this);
    ContentList content = new ContentList(this);

    protected Element() {
    }

    public Element(String string, Namespace namespace) {
        this.setName(string);
        this.setNamespace(namespace);
    }

    public Element(String string) {
        this(string, (Namespace)null);
    }

    public Element(String string, String string2) {
        this(string, Namespace.getNamespace("", string2));
    }

    public Element(String string, String string2, String string3) {
        this(string, Namespace.getNamespace(string2, string3));
    }

    public String getName() {
        return this.m_Name;
    }

    public Element setName(String string) {
        this.m_Name = string;
        return this;
    }

    public Namespace getNamespace() {
        return this.m_Namespace;
    }

    public Element setNamespace(Namespace namespace) {
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        this.m_Namespace = namespace;
        return this;
    }

    public String getNamespacePrefix() {
        return this.m_Namespace.getPrefix();
    }

    public String getNamespaceURI() {
        return this.m_Namespace.getURI();
    }

    public Namespace getNamespace(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("xml")) {
            return Namespace.XML_NAMESPACE;
        }
        if (string.equals(this.getNamespacePrefix())) {
            return this.getNamespace();
        }
        if (this.additionalNamespaces != null) {
            for (int i = 0; i < this.additionalNamespaces.size(); ++i) {
                Namespace namespace = this.additionalNamespaces.get(i);
                if (!string.equals(namespace.getPrefix())) continue;
                return namespace;
            }
        }
        if (this.parent instanceof Element) {
            return ((Element)this.parent).getNamespace(string);
        }
        return null;
    }

    public String getQualifiedName() {
        if (this.m_Namespace.getPrefix().equals("")) {
            return this.getName();
        }
        return new StringBuffer(this.m_Namespace.getPrefix()).append(':').append(this.m_Name).toString();
    }

    public void addNamespaceDeclaration(Namespace namespace) {
        String string = Verifier.checkNamespaceCollision(namespace, this);
        if (string != null) {
            throw new IllegalAddException(this, namespace, string);
        }
        if (this.additionalNamespaces == null) {
            this.additionalNamespaces = new ArrayList<Namespace>(5);
        }
        this.additionalNamespaces.add(namespace);
    }

    public void removeNamespaceDeclaration(Namespace namespace) {
        if (this.additionalNamespaces == null) {
            return;
        }
        this.additionalNamespaces.remove(namespace);
    }

    public List getAdditionalNamespaces() {
        if (this.additionalNamespaces == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.additionalNamespaces);
    }

    @Override
    public String getValue() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Content content : this.getContent()) {
            if (!(content instanceof Element) && !(content instanceof Text)) continue;
            stringBuffer.append(content.getValue());
        }
        return stringBuffer.toString();
    }

    public boolean isRootElement() {
        return this.parent instanceof Document;
    }

    @Override
    public int getContentSize() {
        return this.content.size();
    }

    @Override
    public int indexOf(Content content) {
        return this.content.indexOf(content);
    }

    public String getText() {
        if (this.content.size() == 0) {
            return "";
        }
        if (this.content.size() == 1) {
            Content content = this.content.get(0);
            if (content instanceof Text) {
                return ((Text)content).getText();
            }
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < this.content.size(); ++i) {
            Content content = this.content.get(i);
            if (!(content instanceof Text)) continue;
            stringBuffer.append(((Text)content).getText());
            bl = true;
        }
        if (!bl) {
            return "";
        }
        return stringBuffer.toString();
    }

    public String getTextTrim() {
        return this.getText().trim();
    }

    public String getTextNormalize() {
        return Text.normalizeString(this.getText());
    }

    public String getChildText(String string) {
        Element element = this.getChild(string);
        if (element == null) {
            return null;
        }
        return element.getText();
    }

    public String getChildTextTrim(String string) {
        Element element = this.getChild(string);
        if (element == null) {
            return null;
        }
        return element.getTextTrim();
    }

    public String getChildTextNormalize(String string) {
        Element element = this.getChild(string);
        if (element == null) {
            return null;
        }
        return element.getTextNormalize();
    }

    public String getChildText(String string, Namespace namespace) {
        Element element = this.getChild(string, namespace);
        if (element == null) {
            return null;
        }
        return element.getText();
    }

    public String getChildTextTrim(String string, Namespace namespace) {
        Element element = this.getChild(string, namespace);
        if (element == null) {
            return null;
        }
        return element.getTextTrim();
    }

    public String getChildTextNormalize(String string, Namespace namespace) {
        Element element = this.getChild(string, namespace);
        if (element == null) {
            return null;
        }
        return element.getTextNormalize();
    }

    public Element setText(String string) {
        this.content.clear();
        if (string != null) {
            this.addContent(new Text(string));
        }
        return this;
    }

    @Override
    public List<Content> getContent() {
        return this.content;
    }

    @Override
    public List getContent(Filter filter) {
        return this.content.getView(filter);
    }

    @Override
    public List removeContent() {
        ArrayList<Content> arrayList = new ArrayList<Content>(this.content);
        this.content.clear();
        return arrayList;
    }

    @Override
    public List<Content> removeContent(Filter filter) {
        ArrayList<Content> arrayList = new ArrayList<Content>();
        Iterator<Content> iterator = this.content.getView(filter).iterator();
        while (iterator.hasNext()) {
            Content content = iterator.next();
            arrayList.add(content);
            iterator.remove();
        }
        return arrayList;
    }

    public Element setContent(Collection<? extends Content> collection) {
        this.content.clearAndSet(collection);
        return this;
    }

    public Element setContent(int n, Content content) {
        this.content.set(n, content);
        return this;
    }

    public Parent setContent(int n, Collection<? extends Content> collection) {
        this.content.remove(n);
        this.content.addAll(n, collection);
        return this;
    }

    public Element addContent(String string) {
        return this.addContent(new Text(string));
    }

    public Element addContent(Content content) {
        this.content.add(content);
        return this;
    }

    public Element addContent(Collection<? extends Content> collection) {
        this.content.addAll(collection);
        return this;
    }

    public Element addContent(int n, Content content) {
        this.content.add(n, content);
        return this;
    }

    public Element addContent(int n, Collection<? extends Content> collection) {
        this.content.addAll(n, collection);
        return this;
    }

    @Override
    public List<Content> cloneContent() {
        int n = this.getContentSize();
        ArrayList<Content> arrayList = new ArrayList<Content>(n);
        for (int i = 0; i < n; ++i) {
            Content content = this.getContent(i);
            arrayList.add((Content)content.clone());
        }
        return arrayList;
    }

    @Override
    public Content getContent(int n) {
        return this.content.get(n);
    }

    @Override
    public boolean removeContent(Content content) {
        return this.content.remove(content);
    }

    @Override
    public Content removeContent(int n) {
        return this.content.remove(n);
    }

    public Element setContent(Content content) {
        this.content.clear();
        this.content.add(content);
        return this;
    }

    public boolean isAncestor(Element element) {
        Parent parent = element.getParent();
        while (parent instanceof Element) {
            if (parent == this) {
                return true;
            }
            parent = ((Element)parent).getParent();
        }
        return false;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public Attribute getAttribute(String string) {
        return this.getAttribute(string, Namespace.NO_NAMESPACE);
    }

    public Attribute getAttribute(String string, Namespace namespace) {
        return (Attribute)this.attributes.get(string, namespace);
    }

    public String getAttributeValue(String string) {
        return this.getAttributeValue(string, Namespace.NO_NAMESPACE);
    }

    public String getAttributeValue(String string, String string2) {
        return this.getAttributeValue(string, Namespace.NO_NAMESPACE, string2);
    }

    public String getAttributeValue(String string, Namespace namespace) {
        return this.getAttributeValue(string, namespace, null);
    }

    public String getAttributeValue(String string, Namespace namespace, String string2) {
        Attribute attribute = (Attribute)this.attributes.get(string, namespace);
        return attribute == null ? string2 : attribute.getValue();
    }

    public Element setAttributes(List list) {
        this.attributes.clearAndSet(list);
        return this;
    }

    public Element setAttribute(String string, String string2) {
        return this.setAttribute(new Attribute(string, string2));
    }

    public Element setAttribute(String string, String string2, Namespace namespace) {
        return this.setAttribute(new Attribute(string, string2, namespace));
    }

    public Element setAttribute(Attribute attribute) {
        this.attributes.add(attribute);
        return this;
    }

    public boolean removeAttribute(String string) {
        return this.removeAttribute(string, Namespace.NO_NAMESPACE);
    }

    public boolean removeAttribute(String string, Namespace namespace) {
        return this.attributes.remove(string, namespace);
    }

    public boolean removeAttribute(Attribute attribute) {
        return this.attributes.remove(attribute);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64).append("[Element: <").append(this.getQualifiedName());
        String string = this.getNamespaceURI();
        if (!string.equals("")) {
            stringBuffer.append(" [Namespace: ").append(string).append("]");
        }
        stringBuffer.append("/>]");
        return stringBuffer.toString();
    }

    @Override
    public Object clone() {
        Object object;
        int n;
        Element element = null;
        element = (Element)super.clone();
        element.content = new ContentList(element);
        element.attributes = new AttributeList(element);
        if (this.attributes != null) {
            for (n = 0; n < this.attributes.size(); ++n) {
                Object object2 = this.attributes.get(n);
                object = (Attribute)((Attribute)object2).clone();
                element.attributes.add(object);
            }
        }
        if (this.additionalNamespaces != null) {
            n = this.additionalNamespaces.size();
            element.additionalNamespaces = new ArrayList<Namespace>(n);
            for (int i = 0; i < n; ++i) {
                object = this.additionalNamespaces.get(i);
                element.additionalNamespaces.add((Namespace)object);
            }
        }
        if (this.content != null) {
            for (n = 0; n < this.content.size(); ++n) {
                Content content = this.content.get(n);
                if (content instanceof Element) {
                    object = (Element)((Element)content).clone();
                    element.content.add(object);
                    continue;
                }
                if (content instanceof CDATA) {
                    object = (CDATA)((CDATA)content).clone();
                    element.content.add(object);
                    continue;
                }
                if (content instanceof Text) {
                    object = (Text)((Text)content).clone();
                    element.content.add(object);
                    continue;
                }
                if (content instanceof Comment) {
                    object = (Comment)((Comment)content).clone();
                    element.content.add(object);
                    continue;
                }
                if (content instanceof ProcessingInstruction) {
                    object = (ProcessingInstruction)((ProcessingInstruction)content).clone();
                    element.content.add(object);
                    continue;
                }
                if (!(content instanceof EntityRef)) continue;
                object = (EntityRef)((EntityRef)content).clone();
                element.content.add(object);
            }
        }
        if (this.additionalNamespaces != null) {
            element.additionalNamespaces = new ArrayList<Namespace>();
            element.additionalNamespaces.addAll(this.additionalNamespaces);
        }
        return element;
    }

    @Override
    public Iterator getDescendants() {
        return new DescendantIterator(this);
    }

    @Override
    public Iterator getDescendants(Filter filter) {
        return new FilterIterator(new DescendantIterator(this), filter);
    }

    public final List<Element> getChildren() {
        return this._getChildren();
    }

    private List _getChildren() {
        return this.content.getView(new ElementFilter());
    }

    public final List<Element> getChildren(String string) {
        return this._getChildren(string, Namespace.NO_NAMESPACE);
    }

    public final List<Element> getChildren(String string, Namespace namespace) {
        return this._getChildren(string, namespace);
    }

    private List _getChildren(String string, Namespace namespace) {
        return this.content.getView(new ElementFilter(string, namespace));
    }

    public Element getChild(String string, Namespace namespace) {
        List<Content> list = this.content.getView(new ElementFilter(string, namespace));
        Iterator<Content> iterator = list.iterator();
        if (iterator.hasNext()) {
            return (Element)iterator.next();
        }
        return null;
    }

    public Element getChild(String string) {
        return this.getChild(string, Namespace.NO_NAMESPACE);
    }

    public boolean removeChild(String string) {
        return this.removeChild(string, Namespace.NO_NAMESPACE);
    }

    public boolean removeChild(String string, Namespace namespace) {
        List<Content> list = this.content.getView(new ElementFilter(string, namespace));
        Iterator<Content> iterator = list.iterator();
        if (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean removeChildren(String string) {
        return this.removeChildren(string, Namespace.NO_NAMESPACE);
    }

    public boolean removeChildren(String string, Namespace namespace) {
        boolean bl = false;
        List<Content> list = this.content.getView(new ElementFilter(string, namespace));
        Iterator<Content> iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
            bl = true;
        }
        return bl;
    }
}

