/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jdom;

import com.elixirtech.jdom.IllegalNameException;
import com.elixirtech.jdom.Verifier;
import java.util.HashMap;
import java.util.Map;

public final class Namespace {
    private static Map<String, Namespace> namespaces;
    public static final Namespace NO_NAMESPACE;
    public static final Namespace XML_NAMESPACE;
    private String prefix;
    private String uri;

    public static Namespace getNamespace(String string, String string2) {
        if (string == null || string.trim().equals("")) {
            string = "";
        }
        if (string2 == null || string2.trim().equals("")) {
            string2 = "";
        }
        if (string.trim().equals("xml") && string2.equals("")) {
            return XML_NAMESPACE;
        }
        String string3 = new StringBuffer(64).append(string).append('&').append(string2).toString();
        Namespace namespace = namespaces.get(string3);
        if (namespace != null) {
            return namespace;
        }
        String string4 = Verifier.checkNamespacePrefix(string);
        if (string4 != null) {
            throw new IllegalNameException(string, "Namespace prefix", string4);
        }
        string4 = Verifier.checkNamespaceURI(string2);
        if (string4 != null) {
            throw new IllegalNameException(string2, "Namespace URI", string4);
        }
        if (!string.equals("") && string2.equals("")) {
            throw new IllegalNameException("", "namespace", "Namespace URIs must be non-null and non-empty Strings");
        }
        if (string.equals("xml")) {
            throw new IllegalNameException(string, "Namespace prefix", "The xml prefix can only be bound to http://www.w3.org/XML/1998/namespace");
        }
        if (string2.equals("http://www.w3.org/XML/1998/namespace")) {
            throw new IllegalNameException(string2, "Namespace URI", "The http://www.w3.org/XML/1998/namespace must be bound to the xml prefix.");
        }
        Namespace namespace2 = new Namespace(string, string2);
        namespaces.put(string3, namespace2);
        return namespace2;
    }

    public static Namespace getNamespace(String string) {
        return Namespace.getNamespace("", string);
    }

    private Namespace(String string, String string2) {
        this.prefix = string;
        this.uri = string2;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getURI() {
        return this.uri;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Namespace) {
            return this.uri.equals(((Namespace)object).uri);
        }
        return false;
    }

    public String toString() {
        return "[Namespace: prefix \"" + this.prefix + "\" is mapped to URI \"" + this.uri + "\"]";
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    static {
        NO_NAMESPACE = new Namespace("", "");
        XML_NAMESPACE = new Namespace("xml", "http://www.w3.org/XML/1998/namespace");
        namespaces = new HashMap<String, Namespace>();
        namespaces.put("&", NO_NAMESPACE);
        namespaces.put("xml&http://www.w3.org/XML/1998/namespace", XML_NAMESPACE);
    }
}

