/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jdom.output;

import com.elixirtech.jdom.Namespace;
import java.util.Stack;

public class NamespaceStack {
    private Stack<String> prefixes = new Stack();
    private Stack<String> uris = new Stack();

    NamespaceStack() {
    }

    public void push(Namespace namespace) {
        this.prefixes.push(namespace.getPrefix());
        this.uris.push(namespace.getURI());
    }

    public String pop() {
        String string = this.prefixes.pop();
        this.uris.pop();
        return string;
    }

    public int size() {
        return this.prefixes.size();
    }

    public String getURI(String string) {
        int n = this.prefixes.lastIndexOf(string);
        if (n == -1) {
            return null;
        }
        return (String)this.uris.elementAt(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("Stack: " + this.prefixes.size() + string);
        for (int i = 0; i < this.prefixes.size(); ++i) {
            stringBuffer.append((String)this.prefixes.elementAt(i) + "&" + (String)this.uris.elementAt(i) + string);
        }
        return stringBuffer.toString();
    }
}

