/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jdom.transform;

import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.JDOMException;
import com.elixirtech.jdom.output.SAXOutputter;
import com.elixirtech.jdom.output.XMLOutputter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class JDOMSource
extends SAXSource {
    public static final String JDOM_FEATURE = "http://org.jdom.transform.JDOMSource/feature";
    private XMLReader xmlReader;

    public JDOMSource(Document document) {
        this.setDocument(document);
    }

    public JDOMSource(List list) {
        this.setNodes(list);
    }

    public JDOMSource(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.add(element);
        this.setNodes(arrayList);
    }

    public void setDocument(Document document) {
        super.setInputSource(new JDOMInputSource(document));
    }

    public Document getDocument() {
        Object object = ((JDOMInputSource)this.getInputSource()).getSource();
        Document document = null;
        if (object instanceof Document) {
            document = (Document)object;
        }
        return document;
    }

    public void setNodes(List list) {
        super.setInputSource(new JDOMInputSource(list));
    }

    public List getNodes() {
        Object object = ((JDOMInputSource)this.getInputSource()).getSource();
        List list = null;
        if (object instanceof List) {
            list = (List)object;
        }
        return list;
    }

    @Override
    public void setInputSource(InputSource inputSource) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setXMLReader(XMLReader xMLReader) throws UnsupportedOperationException {
        XMLFilter xMLFilter;
        if (xMLReader instanceof XMLFilter) {
            xMLFilter = (XMLFilter)xMLReader;
            while (xMLFilter.getParent() instanceof XMLFilter) {
                xMLFilter = (XMLFilter)xMLFilter.getParent();
            }
        } else {
            throw new UnsupportedOperationException();
        }
        xMLFilter.setParent(new DocumentReader());
        this.xmlReader = xMLReader;
    }

    @Override
    public XMLReader getXMLReader() {
        if (this.xmlReader == null) {
            this.xmlReader = new DocumentReader();
        }
        return this.xmlReader;
    }

    private static class JDOMInputSource
    extends InputSource {
        private Object source;

        public JDOMInputSource(Document document) {
            this.source = document;
        }

        public JDOMInputSource(List list) {
            this.source = list;
        }

        public Object getSource() {
            return this.source;
        }

        @Override
        public void setCharacterStream(Reader reader) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reader getCharacterStream() {
            Object object = this.getSource();
            StringReader stringReader = null;
            if (object instanceof Document) {
                stringReader = new StringReader(new XMLOutputter().outputString((Document)object));
            } else if (object instanceof List) {
                stringReader = new StringReader(new XMLOutputter().outputString((List)object));
            }
            return stringReader;
        }
    }

    private static class DocumentReader
    extends SAXOutputter
    implements XMLReader {
        @Override
        public void parse(String string) throws SAXNotSupportedException {
            throw new SAXNotSupportedException("Only JDOM Documents are supported as input");
        }

        @Override
        public void parse(InputSource inputSource) throws SAXException {
            if (inputSource instanceof JDOMInputSource) {
                try {
                    Object object = ((JDOMInputSource)inputSource).getSource();
                    if (object instanceof Document) {
                        this.output((Document)object);
                    }
                    this.output((List)object);
                }
                catch (JDOMException jDOMException) {
                    throw new SAXException(jDOMException.getMessage(), jDOMException);
                }
            } else {
                throw new SAXNotSupportedException("Only JDOM Documents are supported as input");
            }
        }
    }
}

