/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jdom.transform;

import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.transform.JDOMResult;
import com.elixirtech.jdom.transform.JDOMSource;
import com.elixirtech.jdom.transform.XSLTransformException;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

public class XSLTransformer {
    private Templates templates;

    private XSLTransformer(Source source) throws XSLTransformException {
        try {
            this.templates = TransformerFactory.newInstance().newTemplates(source);
        }
        catch (TransformerException transformerException) {
            throw new XSLTransformException("Could not construct XSLTransformer", transformerException);
        }
    }

    public XSLTransformer(String string) throws XSLTransformException {
        this(new StreamSource(string));
    }

    public XSLTransformer(InputStream inputStream) throws XSLTransformException {
        this(new StreamSource(inputStream));
    }

    public XSLTransformer(Reader reader) throws XSLTransformException {
        this(new StreamSource(reader));
    }

    public XSLTransformer(File file) throws XSLTransformException {
        this(new StreamSource(file));
    }

    public XSLTransformer(Document document) throws XSLTransformException {
        this(new JDOMSource(document));
    }

    public List transform(List list) throws XSLTransformException {
        JDOMSource jDOMSource = new JDOMSource(list);
        JDOMResult jDOMResult = new JDOMResult();
        try {
            this.templates.newTransformer().transform(jDOMSource, jDOMResult);
            return jDOMResult.getResult();
        }
        catch (TransformerException transformerException) {
            throw new XSLTransformException("Could not perform transformation", transformerException);
        }
    }

    public Document transform(Document document) throws XSLTransformException {
        JDOMSource jDOMSource = new JDOMSource(document);
        JDOMResult jDOMResult = new JDOMResult();
        try {
            this.templates.newTransformer().transform(jDOMSource, jDOMResult);
            return jDOMResult.getDocument();
        }
        catch (TransformerException transformerException) {
            throw new XSLTransformException("Could not perform transformation", transformerException);
        }
    }
}

