/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.js;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.js.DontWrapWithDoPrivileged;
import com.elixirtech.js.WrapWithDoPrivileged;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class PrivilegedJavaProxy
implements InvocationHandler {
    private final Object m_Proxyee;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(PrivilegedJavaProxy.class);

    public static <T> T getProxy(Class<? extends T> clazz, T t) {
        if (t == null) {
            throw new IllegalArgumentException("The object parameter cannot be null.");
        }
        return clazz.cast(Proxy.newProxyInstance(t.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new PrivilegedJavaProxy(t)));
    }

    private PrivilegedJavaProxy(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Proxyee cannot be null.");
        }
        this.m_Proxyee = object;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Class<?> clazz;
        m_Log.debug((Object)("Calling method " + PrivilegedJavaProxy.getMethodSignature(method)));
        Object object2 = null;
        object2 = PrivilegedJavaProxy.shouldWrapWithDoPrivileged(method) ? this.invokeWithDoPrivileged(method, objectArray) : this.invoke(method, objectArray);
        if (object2 != null && (clazz = this.getReturnedInterface(method)) != null && PrivilegedJavaProxy.shouldWrapWithDoPrivileged(clazz)) {
            return PrivilegedJavaProxy.getProxy(clazz, object2);
        }
        return object2;
    }

    private Object invokeWithDoPrivileged(final Method method, final Object[] objectArray) throws Throwable {
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return method.invoke(PrivilegedJavaProxy.this.m_Proxyee, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    return illegalAccessException;
                }
                catch (InvocationTargetException invocationTargetException) {
                    return invocationTargetException;
                }
            }
        });
        if (object instanceof IllegalAccessException) {
            throw (IllegalAccessException)object;
        }
        if (object instanceof InvocationTargetException) {
            throw this.getTargetException(method, (InvocationTargetException)object);
        }
        return object;
    }

    private Object invoke(Method method, Object[] objectArray) throws Throwable {
        try {
            return method.invoke(this.m_Proxyee, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw this.getTargetException(method, invocationTargetException);
        }
    }

    public static boolean shouldWrapWithDoPrivileged(Class<?> clazz) {
        return clazz.getAnnotation(WrapWithDoPrivileged.class) != null;
    }

    public static boolean shouldWrapWithDoPrivileged(Method method) {
        return method.getAnnotation(DontWrapWithDoPrivileged.class) == null;
    }

    private Class<?> getReturnedInterface(Method method) {
        Class<?> clazz = method.getReturnType();
        if (clazz.isInterface()) {
            return clazz;
        }
        return null;
    }

    private Throwable getTargetException(Method method, InvocationTargetException invocationTargetException) {
        Throwable throwable = invocationTargetException.getCause();
        if (throwable != null) {
            return throwable;
        }
        return new RuntimeException("Failed to call method '" + PrivilegedJavaProxy.getMethodSignature(method) + ". Cause unknown.");
    }

    private static String getMethodSignature(Method method) {
        return method.getClass().getName() + "." + method.getName();
    }
}

