/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn;

import com.elixirtech.limn.ArrayOf3dPoints;
import com.elixirtech.limn.Point3d;

class Generic3dMatrix {
    double xx;
    double xy;
    double xz;
    double xo;
    double yx;
    double yy;
    double yz;
    double yo;
    double zx;
    double zy;
    double zz;
    double zo;

    public Generic3dMatrix() {
        this.makeIdentity();
    }

    public void makeIdentity() {
        this.xx = 1.0;
        this.xy = 0.0;
        this.xz = 0.0;
        this.xo = 0.0;
        this.yx = 0.0;
        this.yy = 1.0;
        this.yz = 0.0;
        this.yo = 0.0;
        this.zx = 0.0;
        this.zy = 0.0;
        this.zz = 1.0;
        this.zo = 0.0;
    }

    public void concatRz(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = this.yx * d2 + this.xx * d3;
        double d5 = this.yy * d2 + this.xy * d3;
        double d6 = this.yz * d2 + this.xz * d3;
        double d7 = this.yo * d2 + this.xo * d3;
        double d8 = this.xx * d2 - this.yx * d3;
        double d9 = this.xy * d2 - this.yy * d3;
        double d10 = this.xz * d2 - this.yz * d3;
        double d11 = this.xo * d2 - this.yo * d3;
        this.xx = d8;
        this.xy = d9;
        this.xz = d10;
        this.xo = d11;
        this.yx = d4;
        this.yy = d5;
        this.yz = d6;
        this.yo = d7;
    }

    public void concatRy(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = this.xx * d2 + this.zx * d3;
        double d5 = this.xy * d2 + this.zy * d3;
        double d6 = this.xz * d2 + this.zz * d3;
        double d7 = this.xo * d2 + this.zo * d3;
        double d8 = this.zx * d2 - this.xx * d3;
        double d9 = this.zy * d2 - this.xy * d3;
        double d10 = this.zz * d2 - this.xz * d3;
        double d11 = this.zo * d2 - this.xo * d3;
        this.xx = d4;
        this.xy = d5;
        this.xz = d6;
        this.xo = d7;
        this.zx = d8;
        this.zy = d9;
        this.zz = d10;
        this.zo = d11;
    }

    public void concatRx(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = this.yx * d2 + this.zx * d3;
        double d5 = this.yy * d2 + this.zy * d3;
        double d6 = this.yz * d2 + this.zz * d3;
        double d7 = this.yo * d2 + this.zo * d3;
        double d8 = this.zx * d2 - this.yx * d3;
        double d9 = this.zy * d2 - this.yy * d3;
        double d10 = this.zz * d2 - this.yz * d3;
        double d11 = this.zo * d2 - this.yo * d3;
        this.yx = d4;
        this.yy = d5;
        this.yz = d6;
        this.yo = d7;
        this.zx = d8;
        this.zy = d9;
        this.zz = d10;
        this.zo = d11;
    }

    public void concatT(double d, double d2, double d3) {
        this.xo += d;
        this.yo += d2;
        this.zo += d3;
    }

    public void concatS(double d, double d2, double d3) {
        this.xx *= d;
        this.xy *= d;
        this.xz *= d;
        this.xo *= d;
        this.yx *= d2;
        this.yy *= d2;
        this.yz *= d2;
        this.yo *= d2;
        this.zx *= d3;
        this.zy *= d3;
        this.zz *= d3;
        this.zo *= d3;
    }

    public void transform(ArrayOf3dPoints arrayOf3dPoints, ArrayOf3dPoints arrayOf3dPoints2) {
        for (int i = 0; i < arrayOf3dPoints.npoints; ++i) {
            double d = arrayOf3dPoints.x[i];
            double d2 = arrayOf3dPoints.y[i];
            double d3 = arrayOf3dPoints.z[i];
            arrayOf3dPoints2.x[i] = d * this.xx + d2 * this.xy + d3 * this.xz + this.xo;
            arrayOf3dPoints2.y[i] = d * this.yx + d2 * this.yy + d3 * this.yz + this.yo;
            arrayOf3dPoints2.z[i] = d * this.zx + d2 * this.zy + d3 * this.zz + this.zo;
        }
    }

    public void transformPoint(Point3d point3d, Point3d point3d2) {
        double d = point3d.x;
        double d2 = point3d.y;
        double d3 = point3d.z;
        point3d2.x = d * this.xx + d2 * this.xy + d3 * this.xz + this.xo;
        point3d2.y = d * this.yx + d2 * this.yy + d3 * this.yz + this.yo;
        point3d2.z = d * this.zx + d2 * this.zy + d3 * this.zz + this.zo;
    }

    public void rotate(ArrayOf3dPoints arrayOf3dPoints, ArrayOf3dPoints arrayOf3dPoints2) {
        for (int i = 0; i < arrayOf3dPoints.npoints; ++i) {
            double d = arrayOf3dPoints.x[i];
            double d2 = arrayOf3dPoints.y[i];
            double d3 = arrayOf3dPoints.z[i];
            arrayOf3dPoints2.x[i] = d * this.xx + d2 * this.xy + d3 * this.xz;
            arrayOf3dPoints2.y[i] = d * this.yx + d2 * this.yy + d3 * this.yz;
            arrayOf3dPoints2.z[i] = d * this.zx + d2 * this.zy + d3 * this.zz;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append("[" + (int)this.xx + "," + (int)this.xy + "," + (int)this.xz + "," + (int)this.xo + "]");
        stringBuffer.append("[" + (int)this.yx + "," + (int)this.yy + "," + (int)this.yz + "," + (int)this.yo + "]");
        stringBuffer.append("[" + (int)this.zx + "," + (int)this.zy + "," + (int)this.zz + "," + (int)this.zo + "]");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    void transformWithTranslation(ArrayOf3dPoints arrayOf3dPoints, ArrayOf3dPoints arrayOf3dPoints2, Point3d point3d) {
        double d = point3d.x;
        double d2 = point3d.y;
        double d3 = point3d.z;
        for (int i = 0; i < arrayOf3dPoints.npoints; ++i) {
            double d4 = arrayOf3dPoints.x[i] + d;
            double d5 = arrayOf3dPoints.y[i] + d2;
            double d6 = arrayOf3dPoints.z[i] + d3;
            arrayOf3dPoints2.x[i] = d4 * this.xx + d5 * this.xy + d6 * this.xz + this.xo;
            arrayOf3dPoints2.y[i] = d4 * this.yx + d5 * this.yy + d6 * this.yz + this.yo;
            arrayOf3dPoints2.z[i] = d4 * this.zx + d5 * this.zy + d6 * this.zz + this.zo;
        }
    }
}

