/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn;

import com.elixirtech.limn.Angle3d;
import com.elixirtech.limn.Camera;
import com.elixirtech.limn.Point3d;
import com.elixirtech.limn.World;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class LimnCanvas
extends JComponent {
    private static final long serialVersionUID = 1L;
    private World m_World;
    private Camera m_Camera;
    private Point3d m_CameraPos = new Point3d();
    private Angle3d m_CameraAngle = new Angle3d();

    public LimnCanvas(World world) {
        this.m_World = world;
        this.m_Camera = new Camera(this.m_World, 1.0471975511965976, this.m_CameraPos, this.m_CameraAngle);
    }

    public void setCameraPos(Point3d point3d) {
        this.m_CameraPos = point3d;
        this.repaint();
    }

    public void setCameraAngle(Angle3d angle3d) {
        this.m_CameraAngle = angle3d;
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension dimension = this.getSize();
        this.m_Camera.setScreenSize(dimension.width, dimension.height);
        this.m_Camera.setOrientation(this.m_CameraPos, this.m_CameraAngle);
        this.m_Camera.updateMatrix();
        Rectangle2D rectangle2D = this.m_Camera.getBoundingBox();
        graphics2D.translate(((double)dimension.width - rectangle2D.getWidth()) / 2.0, ((double)dimension.height - rectangle2D.getHeight()) / 2.0);
        graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
        this.m_Camera.paint(graphics2D);
        graphics2D.setColor(Color.yellow);
        graphics2D.draw(rectangle2D);
    }
}

