/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn;

import com.elixirtech.limn.ArrayOf3dPoints;
import com.elixirtech.limn.IndexingPolygon;
import com.elixirtech.limn.Plane;
import com.elixirtech.limn.RangeD;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

class PolygonComparator
implements Comparator<IndexingPolygon>,
Serializable {
    private static final long serialVersionUID = 1L;

    PolygonComparator() {
    }

    @Override
    public int compare(IndexingPolygon indexingPolygon, IndexingPolygon indexingPolygon2) {
        if (indexingPolygon == indexingPolygon2) {
            return 0;
        }
        int n = 0;
        n = indexingPolygon.getSerial() < indexingPolygon2.getSerial() ? this.comparePolygons(indexingPolygon, indexingPolygon2) : -1 * this.comparePolygons(indexingPolygon2, indexingPolygon);
        return n;
    }

    public int comparePolygons(IndexingPolygon indexingPolygon, IndexingPolygon indexingPolygon2) {
        ArrayOf3dPoints arrayOf3dPoints;
        RangeD rangeD;
        RangeD rangeD2 = indexingPolygon.getZRange();
        if (!rangeD2.intersects(rangeD = indexingPolygon2.getZRange())) {
            return rangeD2.min < rangeD.min ? -1 : 1;
        }
        Plane plane = indexingPolygon.getPlane();
        int n = this.getSide(plane, arrayOf3dPoints = indexingPolygon2.getViewPoints());
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        Plane plane2 = indexingPolygon2.getPlane();
        ArrayOf3dPoints arrayOf3dPoints2 = indexingPolygon.getViewPoints();
        int n2 = this.getSide(plane2, arrayOf3dPoints2);
        return n2;
    }

    private int getSide(Plane plane, ArrayOf3dPoints arrayOf3dPoints) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < arrayOf3dPoints.npoints; ++i) {
            double d = plane.getSide(arrayOf3dPoints.x[i], arrayOf3dPoints.y[i], arrayOf3dPoints.z[i]);
            if (d < -1.0E-5) {
                ++n;
                continue;
            }
            if (!(d > 1.0E-5)) continue;
            ++n2;
        }
        if (n > 0 && n2 == 0) {
            return -1;
        }
        if (n2 > 0 && n == 0) {
            return 1;
        }
        return 0;
    }

    public static class PolygonSorter {
        private List<IndexingPolygon> m_Polygons = new ArrayList<IndexingPolygon>();
        private PolygonComparator m_PC = new PolygonComparator();

        public List<IndexingPolygon> apply(List<IndexingPolygon> list) {
            for (IndexingPolygon indexingPolygon : list) {
                this.add(indexingPolygon);
            }
            return this.m_Polygons;
        }

        public void add(IndexingPolygon indexingPolygon) {
            int n = this.determinePos(indexingPolygon);
            this.m_Polygons.add(n, indexingPolygon);
        }

        public List<IndexingPolygon> getList() {
            return this.m_Polygons;
        }

        private int determinePos(IndexingPolygon indexingPolygon) {
            int n = 0;
            for (int i = 0; i < this.m_Polygons.size(); ++i) {
                int n2 = this.m_PC.compare(indexingPolygon, this.m_Polygons.get(i));
                if (n2 <= 0) continue;
                n = i + 1;
            }
            return n;
        }
    }
}

