/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn;

import com.elixirtech.limn.ArrayOf3dPoints;
import com.elixirtech.limn.Plane;
import com.elixirtech.limn.RP;
import com.elixirtech.limn.RangeD;
import java.awt.geom.Area;
import java.io.Serializable;
import scala.runtime.ModuleSerializationProxy;

public final class PolygonSorter2$
implements Serializable {
    private static final int BEHIND;
    private static final int AHEAD;
    private static final int CONTINUE;
    private static final int DONT_CAREX;
    private static final int DONT_CAREY;
    private static final int DONT_CAREA;
    private static final int DONT_CAREP;
    private static final int DONT_CAREE;
    public static final PolygonSorter2$ MODULE$;

    private PolygonSorter2$() {
    }

    static {
        MODULE$ = new PolygonSorter2$();
        BEHIND = -1;
        AHEAD = 1;
        CONTINUE = 2;
        DONT_CAREX = 10;
        DONT_CAREY = 11;
        DONT_CAREA = 12;
        DONT_CAREP = 13;
        DONT_CAREE = 14;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PolygonSorter2$.class);
    }

    public int BEHIND() {
        return BEHIND;
    }

    public int AHEAD() {
        return AHEAD;
    }

    public int CONTINUE() {
        return CONTINUE;
    }

    public int DONT_CAREX() {
        return DONT_CAREX;
    }

    public int DONT_CAREY() {
        return DONT_CAREY;
    }

    public int DONT_CAREA() {
        return DONT_CAREA;
    }

    public int DONT_CAREP() {
        return DONT_CAREP;
    }

    public int DONT_CAREE() {
        return DONT_CAREE;
    }

    public int sort(RP p1, RP p2) {
        int ret = this.sortOrdered(p1, p2);
        return ret;
    }

    private final int sortOrdered(RP p1, RP p2) {
        RangeD[] r2;
        RangeD[] r1 = p1.r();
        if (!r1[0].intersects((r2 = p2.r())[0])) {
            return this.DONT_CAREX();
        }
        if (!r1[1].intersects(r2[1])) {
            return this.DONT_CAREY();
        }
        if (!r1[2].intersects(r2[2])) {
            if (r1[2].min < r2[2].min) {
                return this.BEHIND();
            }
            return this.AHEAD();
        }
        Area area1 = new Area(p1.area());
        Area area2 = p2.area();
        area1.intersect(area2);
        if (area1.isEmpty()) {
            return this.DONT_CAREA();
        }
        Plane plane1 = p1.plane();
        Plane plane2 = p2.plane();
        ArrayOf3dPoints a1 = p1.viewPoints();
        ArrayOf3dPoints a2 = p2.viewPoints();
        int side1 = this.getSide(plane1, a2);
        if (side1 == this.DONT_CAREP()) {
            return this.DONT_CAREP();
        }
        int side2 = this.getSide(plane2, a1);
        if (side1 == side2) {
            return this.DONT_CAREE();
        }
        if (side1 == this.BEHIND()) {
            return this.BEHIND();
        }
        if (side1 == this.AHEAD()) {
            return this.AHEAD();
        }
        if (side2 == this.BEHIND()) {
            return this.AHEAD();
        }
        if (side2 == this.AHEAD()) {
            return this.BEHIND();
        }
        return side1;
    }

    private final int getSide(Plane p, ArrayOf3dPoints a) {
        int behind = 0;
        int ahead = 0;
        for (int i = 0; i < a.npoints; ++i) {
            double side = p.getSide(a.x[i], a.y[i], a.z[i]);
            if (side < -1.0E-5) {
                ++behind;
                continue;
            }
            if (!(side > 1.0E-5)) continue;
            ++ahead;
        }
        if (behind > 0 && ahead == 0) {
            return this.BEHIND();
        }
        if (ahead > 0 && behind == 0) {
            return this.AHEAD();
        }
        if (behind == 0 && ahead == 0) {
            return this.DONT_CAREP();
        }
        return this.CONTINUE();
    }
}

