/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn.chart;

import com.elixirtech.limn.ArrayOf3dPoints;
import com.elixirtech.limn.Line3d;
import com.elixirtech.limn.Point3d;
import com.elixirtech.limn.RenderContext;
import com.elixirtech.limn.RenderedPolygon;
import com.elixirtech.limn.Util;
import com.elixirtech.limn.chart.AbstractAxisOverlay;
import com.elixirtech.limn.chart.ChartWorld;
import com.elixirtech.limn.chart.IAxisValues;
import com.elixirtech.limn.chart.Label;
import com.elixirtech.limn.chart.LimnUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BaseAxisOverlay
extends AbstractAxisOverlay {
    public static final int TICK_GAP = 10;
    public static final int LABEL_GAP = 30;
    private IAxisValues m_LeftAxisValues;
    private Color m_LeftGridColor = Color.gray;
    private Color m_LeftTickLabelColor = Color.blue;
    private Font m_LeftTickLabelFont = ChartWorld.DEFAULT_LABEL_FONT;
    private String m_LeftLabel;
    private Color m_LeftLabelColor = Color.black;
    private Font m_LeftLabelFont = ChartWorld.DEFAULT_LABEL_FONT;
    private IAxisValues m_RightAxisValues;
    private Color m_RightGridColor = Color.gray;
    private Color m_RightTickLabelColor = Color.blue;
    private Font m_RightTickLabelFont = ChartWorld.DEFAULT_LABEL_FONT;
    private String m_RightLabel;
    private Color m_RightLabelColor = Color.black;
    private Font m_RightLabelFont = ChartWorld.DEFAULT_LABEL_FONT;

    public BaseAxisOverlay(IAxisValues iAxisValues, IAxisValues iAxisValues2) {
        this.m_LeftAxisValues = iAxisValues;
        this.m_RightAxisValues = iAxisValues2;
    }

    public void setLeftTickUi(Color color, Color color2, Font font) {
        this.m_LeftGridColor = color;
        this.m_LeftTickLabelColor = color2;
        this.m_LeftTickLabelFont = font;
    }

    public void setLeftLabelUi(String string, Color color, Font font) {
        this.m_LeftLabel = string;
        this.m_LeftLabelColor = color;
        this.m_LeftLabelFont = font;
    }

    public void setRightTickUi(Color color, Color color2, Font font) {
        this.m_RightGridColor = color;
        this.m_RightTickLabelColor = color2;
        this.m_RightTickLabelFont = font;
    }

    public void setRightLabelUi(String string, Color color, Font font) {
        this.m_RightLabel = string;
        this.m_RightLabelColor = color;
        this.m_RightLabelFont = font;
    }

    @Override
    public void buildLabels(RenderContext renderContext, ArrayOf3dPoints arrayOf3dPoints, List<Label> list) {
        this.buildLeftLabels(renderContext, arrayOf3dPoints, list);
        this.buildRightLabels(renderContext, arrayOf3dPoints, list);
    }

    public void buildLeftLabels(RenderContext renderContext, ArrayOf3dPoints arrayOf3dPoints, List<Label> list) {
        if (this.m_LeftAxisValues != null && this.m_LeftAxisValues.isShowAxis()) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
            FontRenderContext fontRenderContext = renderContext.getFontRenderContext();
            Line3d line3d = new Line3d(arrayOf3dPoints.getPoint(1), arrayOf3dPoints.getPoint(6));
            Line3d line3d2 = new Line3d(arrayOf3dPoints.getPoint(0), arrayOf3dPoints.getPoint(5));
            if (this.m_LeftAxisValues.isShowTickLabels()) {
                object5 = new Line3d(arrayOf3dPoints.getPoint(0), arrayOf3dPoints.getPoint(1));
                object4 = new Line3d(arrayOf3dPoints.getPoint(5), arrayOf3dPoints.getPoint(6));
                object3 = ((Line3d)object5).extend(10.0);
                object2 = ((Line3d)object4).extend(10.0);
                object = new Line3d((Point3d)object3, (Point3d)object2);
                int n = this.m_LeftAxisValues.getPositionCount();
                for (int i = 0; i < n; ++i) {
                    IAxisValues.Position position = this.m_LeftAxisValues.getPosition(i);
                    double d = position.location * 100.0;
                    Point3d point3d = ((Line3d)object).position(d);
                    ArrayOf3dPoints arrayOf3dPoints2 = new ArrayOf3dPoints(1);
                    arrayOf3dPoints2.setPoint(0, point3d.x, point3d.y - 5.0, point3d.z);
                    ArrayOf3dPoints arrayOf3dPoints3 = renderContext.project(arrayOf3dPoints2);
                    Point point = new Point((int)arrayOf3dPoints3.x[0], (int)arrayOf3dPoints3.y[0]);
                    Label label = new Label(position.label, point, 3, 4, this.m_LeftTickLabelColor, this.m_LeftTickLabelFont);
                    arrayList.add(label.getBoundingBox(fontRenderContext));
                    list.add(label);
                }
            }
            if (Util.notEmpty(this.m_LeftLabel)) {
                object5 = line3d2.position(50.0);
                object4 = line3d.position(50.0);
                object3 = new ArrayOf3dPoints(2);
                ((ArrayOf3dPoints)object3).setPoint(0, ((Point3d)object5).x, ((Point3d)object5).y, ((Point3d)object5).z);
                ((ArrayOf3dPoints)object3).setPoint(1, ((Point3d)object4).x, ((Point3d)object4).y, ((Point3d)object4).z);
                object2 = renderContext.project((ArrayOf3dPoints)object3);
                object = LimnUtil.extend(((ArrayOf3dPoints)object2).x[0], ((ArrayOf3dPoints)object2).y[0], ((ArrayOf3dPoints)object2).x[1], ((ArrayOf3dPoints)object2).y[1], 30.0);
                Label label = new Label(this.m_LeftLabel, (Point)object, 3, 4, this.m_LeftLabelColor, this.m_LeftLabelFont);
                if (arrayList.size() > 0) {
                    Rectangle2D rectangle2D = label.getBoundingBox(fontRenderContext);
                    while (this.intersects(rectangle2D, arrayList)) {
                        label.offsetX(-3);
                        label.offsetY(3);
                        rectangle2D = label.getBoundingBox(fontRenderContext);
                    }
                }
                list.add(label);
            }
        }
    }

    public void buildRightLabels(RenderContext renderContext, ArrayOf3dPoints arrayOf3dPoints, List<Label> list) {
        if (this.m_RightAxisValues != null && this.m_RightAxisValues.isShowAxis()) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
            FontRenderContext fontRenderContext = renderContext.getFontRenderContext();
            Line3d line3d = new Line3d(arrayOf3dPoints.getPoint(6), arrayOf3dPoints.getPoint(5));
            Line3d line3d2 = new Line3d(arrayOf3dPoints.getPoint(1), arrayOf3dPoints.getPoint(0));
            if (this.m_RightAxisValues.isShowTickLabels()) {
                object5 = new Line3d(arrayOf3dPoints.getPoint(0), arrayOf3dPoints.getPoint(5));
                object4 = new Line3d(arrayOf3dPoints.getPoint(1), arrayOf3dPoints.getPoint(6));
                object3 = ((Line3d)object5).extend(10.0);
                object2 = ((Line3d)object4).extend(10.0);
                object = new Line3d((Point3d)object3, (Point3d)object2);
                int n = this.m_RightAxisValues.getPositionCount();
                for (int i = 0; i < n; ++i) {
                    IAxisValues.Position position = this.m_RightAxisValues.getPosition(i);
                    double d = position.location * 100.0;
                    Point3d point3d = ((Line3d)object).position(d);
                    ArrayOf3dPoints arrayOf3dPoints2 = new ArrayOf3dPoints(1);
                    arrayOf3dPoints2.setPoint(0, point3d.x, point3d.y - 5.0, point3d.z);
                    ArrayOf3dPoints arrayOf3dPoints3 = renderContext.project(arrayOf3dPoints2);
                    Point point = new Point((int)arrayOf3dPoints3.x[0], (int)arrayOf3dPoints3.y[0]);
                    Label label = new Label(position.label, point, 1, 4, this.m_RightTickLabelColor, this.m_RightTickLabelFont);
                    arrayList.add(label.getBoundingBox(fontRenderContext));
                    list.add(label);
                }
            }
            if (Util.notEmpty(this.m_RightLabel)) {
                object5 = line3d2.position(50.0);
                object4 = line3d.position(50.0);
                object3 = new ArrayOf3dPoints(2);
                ((ArrayOf3dPoints)object3).setPoint(0, ((Point3d)object5).x, ((Point3d)object5).y, ((Point3d)object5).z);
                ((ArrayOf3dPoints)object3).setPoint(1, ((Point3d)object4).x, ((Point3d)object4).y, ((Point3d)object4).z);
                object2 = renderContext.project((ArrayOf3dPoints)object3);
                object = LimnUtil.extend(((ArrayOf3dPoints)object2).x[0], ((ArrayOf3dPoints)object2).y[0], ((ArrayOf3dPoints)object2).x[1], ((ArrayOf3dPoints)object2).y[1], 30.0);
                Label label = new Label(this.m_RightLabel, (Point)object, 1, 4, this.m_RightLabelColor, this.m_RightLabelFont);
                if (arrayList.size() > 0) {
                    Rectangle2D rectangle2D = label.getBoundingBox(fontRenderContext);
                    while (this.intersects(rectangle2D, arrayList)) {
                        label.offsetX(3);
                        label.offsetY(3);
                        rectangle2D = label.getBoundingBox(fontRenderContext);
                    }
                }
                list.add(label);
            }
        }
    }

    @Override
    public void render(Graphics2D graphics2D, RenderContext renderContext, RenderedPolygon renderedPolygon, Polygon polygon) {
        ArrayOf3dPoints arrayOf3dPoints = renderedPolygon.getPolyhedron().getVertices();
        if (this.m_LeftAxisValues != null) {
            this.drawLeftRight(graphics2D, renderContext, arrayOf3dPoints);
        }
        if (this.m_RightAxisValues != null) {
            this.drawRightLeft(graphics2D, renderContext, arrayOf3dPoints);
        }
        ArrayList<Label> arrayList = new ArrayList<Label>();
        this.buildLabels(renderContext, arrayOf3dPoints, arrayList);
        for (Label label : arrayList) {
            label.draw(graphics2D);
        }
    }

    @Override
    public Rectangle2D getBoundingBox(RenderContext renderContext, ArrayOf3dPoints arrayOf3dPoints) {
        ArrayList<Label> arrayList = new ArrayList<Label>();
        this.buildLabels(renderContext, arrayOf3dPoints, arrayList);
        FontRenderContext fontRenderContext = renderContext.getFontRenderContext();
        Rectangle2D rectangle2D = null;
        Iterator iterator = arrayList.iterator();
        if (iterator.hasNext()) {
            rectangle2D = ((Label)iterator.next()).getBoundingBox(fontRenderContext);
            while (iterator.hasNext()) {
                Rectangle2D.union(rectangle2D, ((Label)iterator.next()).getBoundingBox(fontRenderContext), rectangle2D);
            }
        }
        return rectangle2D;
    }

    private void drawLeftRight(Graphics graphics, RenderContext renderContext, ArrayOf3dPoints arrayOf3dPoints) {
        Line3d line3d = new Line3d(arrayOf3dPoints.getPoint(0), arrayOf3dPoints.getPoint(5));
        Line3d line3d2 = new Line3d(arrayOf3dPoints.getPoint(1), arrayOf3dPoints.getPoint(6));
        ArrayOf3dPoints arrayOf3dPoints2 = new ArrayOf3dPoints(2);
        int n = this.m_LeftAxisValues.getPositionCount();
        for (int i = 0; i < n; ++i) {
            IAxisValues.Position position = this.m_LeftAxisValues.getPosition(i);
            double d = position.location * 100.0;
            Point3d point3d = line3d2.position(d);
            Point3d point3d2 = line3d.position(d);
            arrayOf3dPoints2.setPoint(0, point3d.x, point3d.y, point3d.z);
            arrayOf3dPoints2.setPoint(1, point3d2.x, point3d2.y, point3d2.z);
            ArrayOf3dPoints arrayOf3dPoints3 = renderContext.project(arrayOf3dPoints2);
            graphics.setColor(this.m_LeftGridColor);
            graphics.drawLine((int)arrayOf3dPoints3.x[0], (int)arrayOf3dPoints3.y[0], (int)arrayOf3dPoints3.x[1], (int)arrayOf3dPoints3.y[1]);
        }
    }

    private void drawRightLeft(Graphics graphics, RenderContext renderContext, ArrayOf3dPoints arrayOf3dPoints) {
        Line3d line3d = new Line3d(arrayOf3dPoints.getPoint(1), arrayOf3dPoints.getPoint(0));
        Line3d line3d2 = new Line3d(arrayOf3dPoints.getPoint(6), arrayOf3dPoints.getPoint(5));
        ArrayOf3dPoints arrayOf3dPoints2 = new ArrayOf3dPoints(2);
        int n = this.m_RightAxisValues.getPositionCount();
        for (int i = 0; i < n; ++i) {
            IAxisValues.Position position = this.m_RightAxisValues.getPosition(i);
            double d = position.location * 100.0;
            Point3d point3d = line3d2.position(d);
            Point3d point3d2 = line3d.position(d);
            arrayOf3dPoints2.setPoint(0, point3d.x, point3d.y, point3d.z);
            arrayOf3dPoints2.setPoint(1, point3d2.x, point3d2.y, point3d2.z);
            ArrayOf3dPoints arrayOf3dPoints3 = renderContext.project(arrayOf3dPoints2);
            graphics.setColor(this.m_RightGridColor);
            graphics.drawLine((int)arrayOf3dPoints3.x[0], (int)arrayOf3dPoints3.y[0], (int)arrayOf3dPoints3.x[1], (int)arrayOf3dPoints3.y[1]);
        }
    }
}

