/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn.chart;

import com.elixirtech.limn.RenderedPolygon;
import com.elixirtech.limn.ShadedColor;
import com.elixirtech.limn.World;
import com.elixirtech.limn.chart.BaseAxisOverlay;
import com.elixirtech.limn.chart.ChartAxes;
import com.elixirtech.limn.chart.IAxisValues;
import com.elixirtech.limn.chart.LeftAxisOverlay;
import com.elixirtech.limn.chart.RightAxisOverlay;
import java.awt.Color;
import java.awt.Font;
import org.jfree.chart.axis.Axis;

public class ChartWorld
extends World {
    public static final Font DEFAULT_LABEL_FONT = Axis.DEFAULT_TICK_LABEL_FONT;
    private ChartAxes m_Axes;
    private Color m_AxesColor = new Color(255, 255, 255);
    private IAxisValues m_LeftAxisValues;
    private IAxisValues m_RightAxisValues;
    private IAxisValues m_BottomLeftAxisValues;
    private IAxisValues m_BottomRightAxisValues;
    private LeftAxisOverlay m_LeftAxisOverlay;
    private RightAxisOverlay m_RightAxisOverlay;
    private BaseAxisOverlay m_BaseAxisOverlay;

    public ChartWorld(IAxisValues iAxisValues, IAxisValues iAxisValues2, IAxisValues iAxisValues3, IAxisValues iAxisValues4) {
        this.m_LeftAxisValues = iAxisValues;
        this.m_RightAxisValues = iAxisValues2;
        this.m_BottomLeftAxisValues = iAxisValues3;
        this.m_BottomRightAxisValues = iAxisValues4;
    }

    public void setAxesColor(Color color) {
        this.m_AxesColor = color;
    }

    public void build() {
        if (this.m_Axes == null) {
            this.m_Axes = new ChartAxes("chart", this, new ShadedColor(this.m_AxesColor));
            this.setupValues();
        }
    }

    public IAxisValues getLeftAxisValues() {
        return this.m_LeftAxisValues;
    }

    public IAxisValues getRightAxisValues() {
        return this.m_RightAxisValues;
    }

    public IAxisValues getBottomLeftAxisValues() {
        return this.m_BottomLeftAxisValues;
    }

    public IAxisValues getBottomRightAxisValues() {
        return this.m_BottomRightAxisValues;
    }

    public LeftAxisOverlay getLeftAxisOverlay() {
        return this.m_LeftAxisOverlay;
    }

    public RightAxisOverlay getRightAxisOverlay() {
        return this.m_RightAxisOverlay;
    }

    public BaseAxisOverlay getBaseAxisOverlay() {
        return this.m_BaseAxisOverlay;
    }

    private void setupValues() {
        RenderedPolygon renderedPolygon;
        if (this.m_LeftAxisValues != null) {
            renderedPolygon = (RenderedPolygon)this.m_Axes.getPolyhedron().getPolygon(0);
            this.m_LeftAxisOverlay = new LeftAxisOverlay(this.m_LeftAxisValues);
            renderedPolygon.setFace(this.m_LeftAxisOverlay);
        }
        if (this.m_RightAxisValues != null) {
            renderedPolygon = (RenderedPolygon)this.m_Axes.getPolyhedron().getPolygon(1);
            this.m_RightAxisOverlay = new RightAxisOverlay(this.m_RightAxisValues);
            renderedPolygon.setFace(this.m_RightAxisOverlay);
        }
        if (this.m_BottomLeftAxisValues != null || this.m_BottomRightAxisValues != null) {
            renderedPolygon = (RenderedPolygon)this.m_Axes.getPolyhedron().getPolygon(2);
            this.m_BaseAxisOverlay = new BaseAxisOverlay(this.m_BottomLeftAxisValues, this.m_BottomRightAxisValues);
            renderedPolygon.setFace(this.m_BaseAxisOverlay);
        }
    }
}

