/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.map.FillData;
import com.elixirtech.map.IShape;
import com.elixirtech.map.IShapeIterator;
import com.elixirtech.map.IShapes;
import com.elixirtech.map.panel.PointOfInterest;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Plot {
    private IShapes m_Shapes;

    public Plot() {
    }

    public Plot(IShapes iShapes) {
        this.setShapes(iShapes);
    }

    public boolean hasShapes() {
        return this.m_Shapes != null;
    }

    public void setShapes(IShapes iShapes) {
        if (iShapes == null) {
            throw new IllegalArgumentException("shapes==null");
        }
        this.m_Shapes = iShapes;
    }

    public IShapes getShapes() {
        return this.m_Shapes;
    }

    public boolean isOriginBottomLeft() {
        return this.m_Shapes.isOriginBottomLeft();
    }

    public Rectangle2D getBounds() {
        return this.m_Shapes.getBounds();
    }

    public IShape getShapeAt(Point2D point2D) {
        for (IShape iShape : this.m_Shapes.getShapes()) {
            if (!iShape.isHit(point2D)) continue;
            return iShape;
        }
        return null;
    }

    public IShape getShape(int n) {
        List<? extends IShape> list = this.m_Shapes.getShapes();
        if (n < 0 || n >= list.size()) {
            return null;
        }
        return list.get(n);
    }

    public Set<String> getAttributes(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (StringUtil.isEmpty(string)) {
            for (IShape iShape : this.m_Shapes.getShapes()) {
                hashSet.add(iShape.getName());
            }
        } else {
            for (IShape iShape : this.m_Shapes.getShapes()) {
                String string2 = iShape.getAttribute(string);
                if (string2 == null) continue;
                hashSet.add(string2);
            }
        }
        return hashSet;
    }

    public void draw(Graphics2D graphics2D, Color color, Color color2, String string, FillData fillData) {
        Map<Object, Object> map = fillData != null ? fillData.getKeyColorMap() : Collections.emptyMap();
        graphics2D.setStroke(new BasicStroke(0.0f));
        for (IShape iShape : this.m_Shapes.getShapes()) {
            Shape shape;
            int n = iShape.getType();
            if (n == 0 || (shape = iShape.getShape()) == null) continue;
            if (n == 3) {
                String string2 = StringUtil.notEmpty(string) ? iShape.getAttribute(string) : iShape.getName();
                Color color3 = (Color)map.get(string2);
                if (color3 == null) {
                    color3 = color2;
                }
                if (color3 != null) {
                    graphics2D.setColor(color3);
                    graphics2D.fill(shape);
                }
            }
            if (color == null) continue;
            graphics2D.setColor(color);
            graphics2D.draw(shape);
        }
    }

    public static List<PointOfInterest> drawLayer(Graphics2D graphics2D, IShapeIterator iShapeIterator, Color color, Color color2) throws IOException {
        ArrayList<PointOfInterest> arrayList = new ArrayList<PointOfInterest>();
        while (iShapeIterator.hasNext()) {
            IShape iShape = iShapeIterator.next();
            int n = iShape.getType();
            if (n == 0) continue;
            Shape shape = iShape.getShape();
            if (shape != null) {
                if (n == 3 && color != null) {
                    graphics2D.setColor(color);
                    graphics2D.fill(shape);
                }
                if (color2 == null) continue;
                graphics2D.setColor(color2);
                graphics2D.draw(shape);
                continue;
            }
            if (n != 1) continue;
            Rectangle2D rectangle2D = iShape.getBounds();
            Point2D.Double double_ = new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY());
            String string = iShape.getAttribute("POI_ID");
            double d = Double.parseDouble(string);
            String string2 = iShape.getAttribute("POI_NAME");
            if (!StringUtil.notEmpty(string2)) continue;
            arrayList.add(new PointOfInterest((long)d, double_, string2));
        }
        return arrayList;
    }
}

