/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.legend;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.map.FillData;
import com.elixirtech.map.coloring.IColoringAlgorithm;
import com.elixirtech.map.legend.ContinuousLegendItem;
import com.elixirtech.map.legend.ILegendView;
import com.elixirtech.map.model.Font;
import com.elixirtech.map.model.Format;
import com.elixirtech.map.model.Legend;
import com.elixirtech.map.util.Range;
import com.elixirtech.map.view.AbstractView;
import com.elixirtech.ui.StandardColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class ContinuousLegendView
extends AbstractView
implements ILegendView {
    private final IColoringAlgorithm m_Algorithm;
    private Legend m_Legend;
    private int m_FontAscent;
    private FillData m_FillData;
    private final List<ContinuousLegendItem> m_Items = new ArrayList<ContinuousLegendItem>();
    private static final int BORDER_GAP = 4;
    private static final int BAR_GAP = 4;
    private static final int BAR_WIDTH = 10;

    public ContinuousLegendView(IColoringAlgorithm iColoringAlgorithm) {
        if (!iColoringAlgorithm.supportsContinuousRange()) {
            throw new IllegalArgumentException("Incompatible algorithm");
        }
        this.m_Algorithm = iColoringAlgorithm;
    }

    @Override
    public void setLegend(Legend legend) {
        this.m_Legend = legend;
    }

    @Override
    public void setFillData(FillData fillData) {
        this.m_FillData = fillData;
    }

    @Override
    public String getLocation() {
        return this.m_Legend.getLocation();
    }

    @Override
    public Dimension getViewSize(Rectangle rectangle) {
        Range range = this.m_FillData.getValueRange();
        if (range != null) {
            Format format = this.m_Legend.getFormat();
            if (format == null) {
                format = new Format();
            }
            List<Range.Position> list = range.calculateContinuousPositions(format);
            this.m_Items.clear();
            for (Range.Position position : list) {
                ContinuousLegendItem continuousLegendItem = new ContinuousLegendItem(position.label, (float)position.location);
                this.m_Items.add(continuousLegendItem);
            }
            this.sizeLabels();
            if (this.getDirection() == 1) {
                return this.layoutHorizontal(rectangle);
            }
            return this.layoutVertical(rectangle);
        }
        return new Dimension(0, 0);
    }

    private boolean isAscending() {
        String string = this.m_Legend.getSort();
        return !"Descending".equals(string);
    }

    private Dimension layoutVertical(Rectangle rectangle) {
        int n = 0;
        int n2 = this.getVerticalBarLength(rectangle.height);
        boolean bl = this.isAscending();
        int n3 = 4 + this.m_FontAscent / 2;
        for (ContinuousLegendItem continuousLegendItem : this.m_Items) {
            float f = bl ? continuousLegendItem.pos : 1.0f - continuousLegendItem.pos;
            int n4 = n3 + (int)(f * (float)n2);
            int n5 = continuousLegendItem.labelSize.width;
            continuousLegendItem.tickPosition = new Point(14, n4);
            continuousLegendItem.labelPosition = new Point(18, n4 + this.m_FontAscent / 2);
            n = Math.max(n, n5);
        }
        return new Dimension(n + 10 + 4 + 8, rectangle.height);
    }

    private Dimension layoutHorizontal(Rectangle rectangle) {
        int n = this.getHorizontalBarLength(rectangle.width);
        boolean bl = this.isAscending();
        for (ContinuousLegendItem continuousLegendItem : this.m_Items) {
            int n2;
            float f = bl ? continuousLegendItem.pos : 1.0f - continuousLegendItem.pos;
            int n3 = (int)(f * (float)n);
            continuousLegendItem.tickPosition = new Point(n3 + 4, 14);
            if ((n3 = (int)((float)n3 - (float)continuousLegendItem.labelSize.width / 2.0f)) < 0) {
                n3 = 0;
            }
            if (n3 > (n2 = n - continuousLegendItem.labelSize.width)) {
                n3 = n2;
            }
            continuousLegendItem.labelPosition = new Point(n3 + 4, 18 + this.m_FontAscent);
        }
        return new Dimension(rectangle.width, this.m_FontAscent + 10 + 4 + 8);
    }

    private int getDirection() {
        String string = this.m_Legend.getLocation();
        if ("North".equals(string) || "South".equals(string)) {
            return 1;
        }
        if ("East".equals(string) || "West".equals(string)) {
            return 2;
        }
        return 0;
    }

    private int getHorizontalBarLength(int n) {
        return n - 8;
    }

    private int getVerticalBarLength(int n) {
        return n - 8 - this.m_FontAscent;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        graphics2D.setStroke(new BasicStroke(0.0f));
        String string = this.m_Legend.getBackgroundColor();
        String string2 = this.m_Legend.getBorderColor();
        if (StringUtil.notEmpty(string)) {
            graphics2D.setColor(StandardColor.lookup(string, Color.WHITE));
            graphics2D.fill(this.m_Rect);
        }
        if (StringUtil.notEmpty(string2)) {
            graphics2D.setColor(StandardColor.lookup(string2, Color.BLACK));
            graphics2D.draw(this.m_Rect);
        }
        graphics2D.translate(this.m_Rect.x, this.m_Rect.y);
        this.paintBar(graphics2D);
        Font font = this.m_Legend.getFont();
        graphics2D.setFont(font.getAWTFont());
        String string3 = font.getColor();
        graphics2D.setColor(StandardColor.lookup(string3, Color.BLACK));
        for (ContinuousLegendItem continuousLegendItem : this.m_Items) {
            graphics2D.drawString(continuousLegendItem.label, continuousLegendItem.labelPosition.x, continuousLegendItem.labelPosition.y);
        }
        graphics2D.translate(-this.m_Rect.x, -this.m_Rect.y);
    }

    private void paintBar(Graphics2D graphics2D) {
        graphics2D.setColor(Color.black);
        if (this.getDirection() == 1) {
            int n = this.getHorizontalBarLength(this.m_Rect.width);
            graphics2D.drawRect(4, 4, n, 10);
            Rectangle rectangle = new Rectangle(5, 5, n - 1, 9);
            this.m_Algorithm.fillContinuousRange(graphics2D, rectangle, false, this.isAscending());
            graphics2D.setColor(Color.black);
            for (ContinuousLegendItem continuousLegendItem : this.m_Items) {
                Point point = continuousLegendItem.tickPosition;
                graphics2D.drawLine(point.x, point.y, point.x, point.y + 2);
            }
        } else {
            int n = this.getVerticalBarLength(this.m_Rect.height);
            int n2 = 4 + this.m_FontAscent / 2;
            graphics2D.drawRect(4, n2, 10, n);
            Rectangle rectangle = new Rectangle(5, n2 + 1, 9, n - 1);
            this.m_Algorithm.fillContinuousRange(graphics2D, rectangle, true, this.isAscending());
            graphics2D.setColor(Color.black);
            for (ContinuousLegendItem continuousLegendItem : this.m_Items) {
                Point point = continuousLegendItem.tickPosition;
                graphics2D.drawLine(point.x, point.y, point.x + 2, point.y);
            }
        }
    }

    private void sizeLabels() {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.m_Legend.getFont().getAWTFont());
        this.m_FontAscent = fontMetrics.getAscent();
        int n = fontMetrics.getHeight();
        for (ContinuousLegendItem continuousLegendItem : this.m_Items) {
            int n2 = fontMetrics.stringWidth(continuousLegendItem.label);
            continuousLegendItem.labelSize = new Dimension(n2, n);
        }
        graphics2D.dispose();
        bufferedImage.flush();
    }
}

