/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.model;

import com.elixirtech.map.model.BasicMapSourceSAX;
import com.elixirtech.map.model.Layer;
import com.elixirtech.map.model.LayerSAX;
import com.elixirtech.map.model.Legend;
import com.elixirtech.map.model.LegendSAX;
import com.elixirtech.map.model.MapFile;
import com.elixirtech.map.model.MapSource;
import com.elixirtech.map.model.Metadata;
import com.elixirtech.map.model.MetadataSAX;
import com.elixirtech.map.model.Parameter;
import com.elixirtech.map.model.ParameterSAX;
import com.elixirtech.map.model.Security;
import com.elixirtech.map.model.SecuritySAX;
import com.elixirtech.map.model.ShapefileSAX;
import com.elixirtech.map.model.Title;
import com.elixirtech.map.model.TitleSAX;
import com.elixirtech.sax.BasicSAXDelegate;
import org.xml.sax.Attributes;

public class MapFileSAX
extends BasicSAXDelegate {
    protected MapFile m_MapFile;
    private String m_Tag;

    public MapFileSAX() {
        this("mapfile");
    }

    public MapFileSAX(String string) {
        this.m_Tag = string;
        this.setMapFile(new MapFile());
    }

    public String getTag() {
        return this.m_Tag;
    }

    protected void setMapFile(MapFile mapFile) {
        this.m_MapFile = mapFile;
    }

    @Override
    public Object getObject() {
        return this.m_MapFile;
    }

    @Override
    protected void doStart(String string, Attributes attributes) {
        if (!this.m_AttributesInitialized && string.equals(this.m_Tag)) {
            this.initAttributes(attributes);
        } else if (string.equals("legend")) {
            this.m_Delegate = new LegendSAX("legend");
        } else if (string.equals("title")) {
            this.m_Delegate = new TitleSAX("title");
        } else if (string.equals("metadata")) {
            this.m_Delegate = new MetadataSAX("metadata");
        } else if (string.equals("security")) {
            this.m_Delegate = new SecuritySAX("security");
        } else if (string.equals("shapefile")) {
            this.m_Delegate = new ShapefileSAX("shapefile");
        } else if (string.equals("basic-mapsource")) {
            this.m_Delegate = new BasicMapSourceSAX("basic-mapsource");
        } else if (string.equals("layer")) {
            this.m_Delegate = new LayerSAX("layer");
        } else if (string.equals("param")) {
            this.m_Delegate = new ParameterSAX("param");
        } else {
            super.doStart(string, attributes);
        }
    }

    @Override
    protected void initAttributes(Attributes attributes) {
        this.m_MapFile.setBackgroundColor(attributes.getValue("background-color"));
        this.m_MapFile.setForegroundColor(attributes.getValue("foreground-color"));
        this.m_MapFile.setLineColor(attributes.getValue("line-color"));
        this.m_MapFile.setColoringAlgorithm(attributes.getValue("coloring-algorithm"));
        String string = attributes.getValue("start-at-zero");
        if (string != null) {
            this.m_MapFile.setStartAtZero("Yes".equals(string));
        }
        this.m_MapFile.setMapKey(attributes.getValue("map-key"));
        this.m_MapFile.setDSKey(attributes.getValue("ds-key"));
        this.m_MapFile.setToolTip(attributes.getValue("tooltip"));
        this.m_MapFile.setDataSource(attributes.getValue("datasource"));
        super.initAttributes(attributes);
    }

    @Override
    protected void doEnd(String string) {
        if (string.equals("legend")) {
            this.m_MapFile.setLegend((Legend)this.m_Delegate.getObject());
        } else if (string.equals("title")) {
            this.m_MapFile.setTitle((Title)this.m_Delegate.getObject());
        } else if (string.equals("metadata")) {
            this.m_MapFile.setMetadata((Metadata)this.m_Delegate.getObject());
        } else if (string.equals("security")) {
            this.m_MapFile.setSecurity((Security)this.m_Delegate.getObject());
        } else if (string.equals("shapefile")) {
            this.m_MapFile.setMapSource((MapSource)this.m_Delegate.getObject());
        } else if (string.equals("basic-mapsource")) {
            this.m_MapFile.setMapSource((MapSource)this.m_Delegate.getObject());
        } else if (string.equals("layer")) {
            Layer layer = (Layer)this.m_Delegate.getObject();
            this.m_MapFile.addLayer(layer);
        } else if (string.equals("param")) {
            Parameter parameter = (Parameter)this.m_Delegate.getObject();
            this.m_MapFile.addParameter(parameter);
        } else {
            super.doEnd(string);
        }
    }
}

