/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.model;

import com.elixirtech.map.model.MapFile;
import com.elixirtech.sax.IBean;
import com.elixirtech.sax.IBeanSAXOut;
import com.elixirtech.sax.ISAXOut;
import org.xml.sax.helpers.AttributesImpl;

public class MapFileSAXOut
implements IBeanSAXOut {
    @Override
    public String getTagName() {
        return "mapfile";
    }

    @Override
    public void output(ISAXOut iSAXOut, IBean iBean) {
        MapFile mapFile = (MapFile)iBean;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.buildAttributes(mapFile, attributesImpl);
        iSAXOut.startElement(iBean.getTagName(), attributesImpl);
        this.outputChild(iSAXOut, mapFile);
        this.outputChildren(iSAXOut, mapFile);
        iSAXOut.endElement(iBean.getTagName());
    }

    @Override
    public void output(ISAXOut iSAXOut, IBean iBean, String string) {
        MapFile mapFile = (MapFile)iBean;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.buildAttributes(mapFile, attributesImpl);
        iSAXOut.startElement(string, attributesImpl);
        this.outputChild(iSAXOut, mapFile);
        this.outputChildren(iSAXOut, mapFile);
        iSAXOut.endElement(string);
    }

    public void buildAttributes(MapFile mapFile, AttributesImpl attributesImpl) {
        String string;
        String string2 = mapFile.getBackgroundColor();
        if (string2 != null) {
            string = "background-color";
            attributesImpl.addAttribute("", string, string, "CDATA", string2);
        }
        if ((string2 = mapFile.getForegroundColor()) != null) {
            string = "foreground-color";
            attributesImpl.addAttribute("", string, string, "CDATA", string2);
        }
        if ((string2 = mapFile.getLineColor()) != null) {
            string = "line-color";
            attributesImpl.addAttribute("", string, string, "CDATA", string2);
        }
        if ((string2 = mapFile.getColoringAlgorithm()) != null) {
            string = "coloring-algorithm";
            attributesImpl.addAttribute("", string, string, "CDATA", string2);
        }
        string2 = "start-at-zero";
        attributesImpl.addAttribute("", string2, string2, "CDATA", mapFile.isStartAtZero() ? "Yes" : "No");
        string2 = mapFile.getMapKey();
        if (string2 != null) {
            string = "map-key";
            attributesImpl.addAttribute("", string, string, "CDATA", string2);
        }
        if ((string2 = mapFile.getDSKey()) != null) {
            string = "ds-key";
            attributesImpl.addAttribute("", string, string, "CDATA", string2);
        }
        if ((string2 = mapFile.getToolTip()) != null) {
            string = "tooltip";
            attributesImpl.addAttribute("", string, string, "CDATA", string2);
        }
        if ((string2 = mapFile.getDataSource()) != null) {
            string = "datasource";
            attributesImpl.addAttribute("", string, string, "CDATA", string2);
        }
    }

    public void outputChild(ISAXOut iSAXOut, MapFile mapFile) {
        iSAXOut.output(mapFile.getLegend(), "legend");
        iSAXOut.output(mapFile.getTitle(), "title");
        iSAXOut.output(mapFile.getMetadata(), "metadata");
        iSAXOut.output(mapFile.getSecurity(), "security");
        iSAXOut.output(mapFile.getMapSource());
    }

    public void outputChildren(ISAXOut iSAXOut, MapFile mapFile) {
        iSAXOut.startElement("layers", new AttributesImpl());
        iSAXOut.output(mapFile.getLayerIterator());
        iSAXOut.endElement("layers");
        iSAXOut.startElement("parameters", new AttributesImpl());
        iSAXOut.output(mapFile.getParameterIterator());
        iSAXOut.endElement("parameters");
    }
}

