/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.panel;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.map.FillData;
import com.elixirtech.map.IShape;
import com.elixirtech.map.IShapes;
import com.elixirtech.map.Plot;
import com.elixirtech.map.coloring.ColoringAlgorithmFactory;
import com.elixirtech.map.coloring.IColoringAlgorithm;
import com.elixirtech.map.legend.ContinuousLegendView;
import com.elixirtech.map.legend.DiscreteLegendView;
import com.elixirtech.map.legend.ILegendView;
import com.elixirtech.map.model.Layer;
import com.elixirtech.map.model.Legend;
import com.elixirtech.map.model.MapFile;
import com.elixirtech.map.model.Title;
import com.elixirtech.map.panel.IMapHost;
import com.elixirtech.map.panel.PointOfInterest;
import com.elixirtech.map.sax.MapFileLoader;
import com.elixirtech.map.view.IView;
import com.elixirtech.map.view.LayerView;
import com.elixirtech.map.view.PlotView;
import com.elixirtech.map.view.TitleView;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MapView
implements IMapHost,
ArgumentMap.ICallback {
    public static final int POI_RADIUS = 4;
    public static final int POI_RADIUS_SQUARED = 16;
    protected final MapFile m_MapFile;
    protected final PlotView m_PlotView;
    protected FillData m_FillData;
    protected IColoringAlgorithm m_Algorithm;
    protected DataTable m_Table;
    protected int m_DataPrimaryKeyIndex;
    protected List<PointOfInterest> m_PointsOfInterest = new ArrayList<PointOfInterest>();
    protected static final int BORDER = 10;

    public MapView(MapFile mapFile) {
        this.m_MapFile = mapFile;
        this.m_PlotView = new PlotView(this, this.m_MapFile);
    }

    public void refresh() {
        this.refreshShapes();
        this.refreshData();
    }

    public void refreshShapes() {
        if (this.m_MapFile != null) {
            IShapes iShapes = null;
            try {
                iShapes = MapFileLoader.loadShapes(this.m_MapFile.getMapSource());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (iShapes != null) {
                DataSchema dataSchema;
                DataTable dataTable;
                if (StringUtil.isEmpty(this.m_MapFile.getMapKey()) && (dataTable = iShapes.getRecords()) != null && (dataSchema = dataTable.getSchema()).getColumnCount() > 0) {
                    this.m_MapFile.setMapKey(dataSchema.getColumnName(0));
                }
                this.m_PlotView.setPlot(new Plot(iShapes));
            } else {
                this.m_PlotView.setPlot(null);
            }
        }
    }

    public void refreshData() {
        if (this.m_PlotView.getPlot() == null) {
            return;
        }
        try {
            this.buildDataTable();
            this.m_DataPrimaryKeyIndex = this.getDataPrimaryKeyIndex();
            this.buildFillMap();
        }
        catch (DataException dataException) {
            this.m_Table = null;
        }
    }

    public String getKey(Point point) {
        String string;
        IShape iShape = this.m_PlotView.getShapeAt(point);
        if (iShape != null && this.m_MapFile != null && StringUtil.notEmpty(string = this.m_MapFile.getMapKey())) {
            return iShape.getAttribute(string);
        }
        return null;
    }

    public String getKey(int n) {
        String string;
        IShape iShape = this.m_PlotView.getShape(n);
        if (iShape != null && this.m_MapFile != null && StringUtil.notEmpty(string = this.m_MapFile.getMapKey())) {
            return iShape.getAttribute(string);
        }
        return null;
    }

    final List<String> getKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.m_MapFile != null) {
            String string = this.m_MapFile.getMapKey();
            IShapes iShapes = this.m_PlotView.getPlot().getShapes();
            for (IShape iShape : iShapes.getShapes()) {
                arrayList.add(iShape.getAttribute(string));
            }
        }
        return arrayList;
    }

    @Override
    public String getValue(String string, String string2) {
        return null;
    }

    protected IDataSource getDataSource() throws DataException {
        if (this.m_MapFile == null) {
            return null;
        }
        String string = this.m_MapFile.getDataSource();
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        return dataSourceManager.getDataSource(dataSourceManager, string);
    }

    protected void buildDataTable() throws DataException {
        IDataSource iDataSource = this.getDataSource();
        if (iDataSource != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            DefaultPushContext defaultPushContext = new DefaultPushContext();
            defaultPushContext.setParameters(hashMap);
            this.m_Table = DataTable.build(defaultPushContext, iDataSource);
        }
    }

    protected int getDataPrimaryKeyIndex() {
        int n = -1;
        int n2 = 0;
        if (this.m_Table != null && this.m_MapFile != null) {
            Set<String> set = this.m_PlotView.getPlot().getAttributes(this.m_MapFile.getMapKey());
            int n3 = this.m_Table.getRecordCount();
            int n4 = this.m_Table.getSchema().getColumnCount();
            for (int i = 0; i < n4; ++i) {
                Set<String> set2 = this.getColumnStrings(i);
                if (set2.size() < n3) continue;
                set2.retainAll(set);
                if (set2.size() <= n2) continue;
                n2 = set2.size();
                n = i;
            }
        }
        return n;
    }

    private Set<String> getColumnStrings(int n) {
        HashSet<String> hashSet = new HashSet<String>();
        DataRecord[] dataRecordArray = this.m_Table.getRecords();
        for (int i = 0; i < dataRecordArray.length; ++i) {
            Object object = dataRecordArray[i].getData(n);
            if (object == null) continue;
            hashSet.add(String.valueOf(object).trim());
        }
        return hashSet;
    }

    public void paint(Graphics2D graphics2D, Dimension dimension) {
        if (this.m_MapFile != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            String string = this.m_MapFile.getBackgroundColor();
            if (StringUtil.notEmpty(string)) {
                graphics2D.setColor(StandardColor.lookup(string));
                graphics2D.fill(new Rectangle(0, 0, dimension.width, dimension.height));
            }
            Rectangle rectangle = new Rectangle(10, 10, dimension.width - 20, dimension.height - 20);
            this.m_PointsOfInterest.clear();
            List<IView> list = this.buildViews();
            for (IView iView : list) {
                rectangle = iView.doLayout(rectangle);
                iView.paint(graphics2D);
            }
        }
    }

    @Override
    public void addPointOfInterest(PointOfInterest pointOfInterest) {
        this.m_PointsOfInterest.add(pointOfInterest);
    }

    @Override
    public Color getPointOfInterestColor(PointOfInterest pointOfInterest, Color color) {
        return color;
    }

    protected List<IView> buildViews() {
        ArrayList<IView> arrayList = new ArrayList<IView>();
        if (this.m_MapFile != null) {
            Title title = this.m_MapFile.getTitle();
            TitleView titleView = new TitleView();
            titleView.setTitle(title);
            titleView.setSubstitution(this);
            arrayList.add(titleView);
            Legend legend = this.m_MapFile.getLegend();
            ILegendView iLegendView = this.createLegendView();
            iLegendView.setLegend(legend);
            iLegendView.setFillData(this.m_FillData);
            arrayList.add(iLegendView);
            arrayList.add(this.m_PlotView);
            for (Layer layer : this.m_MapFile.getLayerList()) {
                if (!layer.isEnabled()) continue;
                arrayList.add(new LayerView(this.m_PlotView, layer));
            }
        }
        return arrayList;
    }

    private ILegendView createLegendView() {
        if (this.m_Algorithm != null && this.m_Algorithm.supportsContinuousRange() && this.m_MapFile != null && this.m_MapFile.getLegend().isContinuousRange() && this.m_FillData.getValueRange() != null) {
            return new ContinuousLegendView(this.m_Algorithm);
        }
        return new DiscreteLegendView();
    }

    public void buildFillMap() {
        DataSchema dataSchema;
        int n;
        String string = this.getFillDataColumn();
        if (this.m_Table != null && this.m_MapFile != null && string != null && this.m_DataPrimaryKeyIndex >= 0 && (n = (dataSchema = this.m_Table.getSchema()).getColumnIndex(string)) >= 0) {
            this.m_FillData = new FillData(dataSchema.getColumnType(n));
            DataRecord[] dataRecordArray = this.m_Table.getRecords();
            for (int i = 0; i < dataRecordArray.length; ++i) {
                Object object = dataRecordArray[i].getData(this.m_DataPrimaryKeyIndex);
                Object object2 = dataRecordArray[i].getData(n);
                this.m_FillData.add(object, object2);
            }
            this.m_FillData.calcRange(this.m_MapFile.isStartAtZero());
            this.m_Algorithm = ColoringAlgorithmFactory.build(this.m_MapFile.getColoringAlgorithm());
            if (this.m_Algorithm != null) {
                this.m_Algorithm.setData(this.m_FillData);
            }
        }
        this.m_PlotView.setFillData(this.m_FillData);
    }

    protected String getFillDataColumn() {
        if (this.m_MapFile == null) {
            return null;
        }
        return this.m_MapFile.getDSKey();
    }

    public String getToolTipText(Point point) {
        PointOfInterest pointOfInterest = this.getPointOfInterest(point);
        if (pointOfInterest != null) {
            return pointOfInterest.getLabel();
        }
        IShape iShape = this.m_PlotView.getShapeAt(point);
        if (iShape != null && this.m_MapFile != null) {
            String string = this.m_MapFile.getMapKey();
            return this.getToolTipText(iShape.getAttribute(string));
        }
        return null;
    }

    public String getToolTipText(String string) {
        return string;
    }

    public PointOfInterest getPointOfInterest(Point point) {
        for (PointOfInterest pointOfInterest : this.m_PointsOfInterest) {
            if (!pointOfInterest.isHit(point)) continue;
            return pointOfInterest;
        }
        return null;
    }
}

