/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.view;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.map.IShape;
import com.elixirtech.map.IShapeIterator;
import com.elixirtech.map.IShapes;
import com.elixirtech.map.ListShapeIterator;
import com.elixirtech.map.Plot;
import com.elixirtech.map.model.Layer;
import com.elixirtech.map.model.MapSource;
import com.elixirtech.map.panel.IMapHost;
import com.elixirtech.map.panel.PointOfInterest;
import com.elixirtech.map.sax.MapFileLoader;
import com.elixirtech.map.view.IView;
import com.elixirtech.map.view.PlotView;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.List;

public class LayerView
implements IView {
    private final PlotView m_PlotView;
    private final Layer m_Layer;
    private List<? extends IShape> m_Shapes;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(LayerView.class);

    public LayerView(PlotView plotView, Layer layer) {
        this.m_PlotView = plotView;
        this.m_Layer = layer;
        if (this.m_Layer.isCache()) {
            try {
                MapSource mapSource = this.m_Layer.getMapSource();
                if (mapSource != null) {
                    IShapes iShapes = MapFileLoader.loadShapes(this.m_Layer.getMapSource());
                    if (iShapes != null) {
                        this.m_Shapes = iShapes.getShapes();
                    } else {
                        m_Log.warn((Object)("Can't cache shapes from " + this.m_Layer.getMapSource().getConfig()));
                    }
                }
            }
            catch (IOException iOException) {
                m_Log.error((Object)("Error loading layer shapes: " + String.valueOf(iOException)), (Throwable)iOException);
            }
        }
    }

    @Override
    public Rectangle doLayout(Rectangle rectangle) {
        return rectangle;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (this.m_PlotView.hasPlot()) {
            try {
                IShapeIterator iShapeIterator;
                MapSource mapSource = this.m_Layer.getMapSource();
                if (mapSource != null && (iShapeIterator = this.loadShapes(mapSource)) != null) {
                    AffineTransform affineTransform = graphics2D.getTransform();
                    AffineTransform affineTransform2 = new AffineTransform(affineTransform);
                    AffineTransform affineTransform3 = this.m_PlotView.getTransform();
                    affineTransform2.concatenate(affineTransform3);
                    graphics2D.setTransform(affineTransform2);
                    Color color = StandardColor.lookup(this.m_Layer.getFillColor());
                    Color color2 = StandardColor.lookup(this.m_Layer.getLineColor());
                    try {
                        m_Log.debug((Object)("Begin drawing of layer " + this.m_Layer.getName()));
                        List<PointOfInterest> list = Plot.drawLayer(graphics2D, iShapeIterator, color, color2);
                        graphics2D.setTransform(affineTransform);
                        IMapHost iMapHost = this.m_PlotView.getPlotPanel();
                        Point2D.Double double_ = new Point2D.Double();
                        for (PointOfInterest pointOfInterest : list) {
                            affineTransform3.transform(pointOfInterest.getViewPoint(), double_);
                            Point point = new Point((int)((Point2D)double_).getX(), (int)((Point2D)double_).getY());
                            pointOfInterest.setPixelPoint(point);
                            iMapHost.addPointOfInterest(pointOfInterest);
                            graphics2D.setColor(iMapHost.getPointOfInterestColor(pointOfInterest, color));
                            graphics2D.fillOval(point.x - 3, point.y - 3, 7, 7);
                        }
                        m_Log.debug((Object)("End drawing of layer " + this.m_Layer.getName()));
                    }
                    catch (IOException iOException) {
                        m_Log.error((Object)("Unabled to draw layer: " + String.valueOf(iOException)), (Throwable)iOException);
                    }
                }
            }
            catch (IOException iOException) {
                m_Log.error((Object)("Error loading layer shapes: " + String.valueOf(iOException)), (Throwable)iOException);
            }
        }
    }

    private IShapeIterator loadShapes(MapSource mapSource) throws IOException {
        if (this.m_Layer.isCache()) {
            if (this.m_Shapes != null) {
                return new ListShapeIterator(this.m_Shapes);
            }
            return null;
        }
        return MapFileLoader.loadShapeIterator(mapSource);
    }
}

