/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.doc;

import com.elixirtech.arch.xml.XMLContent$;
import com.elixirtech.jdom.Element;
import com.elixirtech.opc.BinaryPart;
import com.elixirtech.opc.ContentTypes;
import com.elixirtech.opc.Package;
import com.elixirtech.opc.Part;
import com.elixirtech.opc.Relationship;
import com.elixirtech.opc.RelationshipsPart;
import com.elixirtech.opc.ResourcePart;
import com.elixirtech.opc.XMLPart;
import com.elixirtech.opc.ZipWriter;
import com.elixirtech.opc.doc.DOCConstants$;
import com.elixirtech.opc.doc.DOCNamespaceContext;
import com.elixirtech.opc.doc.Document$;
import com.elixirtech.opc.doc.Footer;
import com.elixirtech.opc.doc.Header;
import com.elixirtech.opc.doc.IDGenerator;
import com.elixirtech.opc.doc.SectionProperties;
import com.elixirtech.opc.doc.Styles;
import com.elixirtech.opc.doc.XMLHolder;
import com.elixirtech.opc.util.XMLUtil$;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ListBuffer;
import scala.runtime.function.JProcedure1;

public class Document
extends XMLPart {
    private final IDGenerator idGenerator = new IDGenerator();
    private Element body = null;
    private final ListBuffer<Part> subParts = new ListBuffer();
    private final Styles styles = new Styles();

    public static String ContentType() {
        return Document$.MODULE$.ContentType();
    }

    public static String Doc() {
        return Document$.MODULE$.Doc();
    }

    public static String DocRels() {
        return Document$.MODULE$.DocRels();
    }

    public static DOCNamespaceContext NSContext() {
        return Document$.MODULE$.NSContext();
    }

    public static Element getElement(Element element, String string) {
        return Document$.MODULE$.getElement(element, string);
    }

    public Document() {
        super("/word/document.xml", Document$.MODULE$.ContentType());
        this.subParts.$plus$eq((Object)this.styles);
        this.setDocument(XMLUtil$.MODULE$.loadResource(Document$.MODULE$.Doc()));
        this.buildExtensionPoints();
        this.buildResources();
        this.buildRelationships();
    }

    public IDGenerator idGenerator() {
        return this.idGenerator;
    }

    public void add(XMLHolder xh) {
        this.body.addContent(XMLContent$.MODULE$.apply(xh.xml()).jdom().detach());
    }

    public void add(SectionProperties sp2) {
        this.body.addContent(XMLContent$.MODULE$.apply(sp2.xml()).jdom().detach());
        this.styles.setBodyWidth(sp2.getBodyWidth());
    }

    public String storeImage(BufferedImage im) {
        String imageName = "image" + this.idGenerator().getImageNo() + ".png";
        String mimeType = "PNG";
        String fullPath = "/word/media/" + imageName;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)im, mimeType, baos);
        this.subParts.$plus$eq((Object)new BinaryPart(fullPath, "image/png", baos.toByteArray()));
        return fullPath;
    }

    public String add(Header header) {
        this.subParts.$plus$eq((Object)header);
        return this.addRelationship(new Relationship(DOCConstants$.MODULE$.TypeHeader(), header.getName().substring(6)));
    }

    public String add(Footer footer) {
        this.subParts.$plus$eq((Object)footer);
        return this.addRelationship(new Relationship(DOCConstants$.MODULE$.TypeFooter(), footer.getName().substring(6)));
    }

    public void output(OutputStream os) {
        Package pkg = new Package();
        RelationshipsPart master = pkg.getRelationships();
        master.addRelationship(new Relationship(DOCConstants$.MODULE$.TypeOfficeDocument(), "word/document.xml"));
        master.addRelationship(new Relationship(DOCConstants$.MODULE$.TypeApp(), "docProps/app.xml"));
        master.addRelationship(new Relationship(DOCConstants$.MODULE$.TypeCore(), "docProps/core.xml"));
        pkg.addPart(this);
        this.subParts.foreach((Function1)(JProcedure1 & Serializable)part -> pkg.addPart((Part)part));
        pkg.addPart(new ContentTypes(pkg));
        ZipWriter.write(pkg, os);
    }

    public void buildExtensionPoints() {
        Element root = this.m_Document.getRootElement();
        this.body = Document$.MODULE$.getElement(root, "/w:document/w:body");
    }

    public void buildResources() {
        this.subParts.$plus$eq((Object)new ResourcePart("/docProps/app.xml", DOCConstants$.MODULE$.CTypeApp(), "com/elixirtech/opc/doc/parts/docProps/app.xml"));
        this.subParts.$plus$eq((Object)new ResourcePart("/docProps/core.xml", DOCConstants$.MODULE$.CTypeCore(), "com/elixirtech/opc/doc/parts/docProps/core.xml"));
        this.subParts.$plus$eq((Object)new ResourcePart("/word/fontTable.xml", DOCConstants$.MODULE$.CTypeFontTable(), "com/elixirtech/opc/doc/parts/word/fontTable.xml"));
    }

    public void buildRelationships() {
        this.initRelationships();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream(Document$.MODULE$.DocRels());
        Predef$.MODULE$.require(is != null);
        this.m_Relationships.loadRelationships(is);
    }
}

