/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.property;

import com.elixirtech.i18n.Name;
import com.elixirtech.property.PropertyImplementor;
import com.elixirtech.property.PropertyNode;
import com.elixirtech.property.PropertyType;

public class Property
extends PropertyNode {
    private final PropertyImplementor m_PropertyImplementor;
    private final int m_Index;

    public Property(PropertyImplementor propertyImplementor, int n) {
        this.m_PropertyImplementor = propertyImplementor;
        this.m_Index = n;
    }

    @Override
    public Name getName() {
        return this.m_PropertyImplementor.getPropertyName(this.m_Index);
    }

    public boolean equals(Object object) {
        if (object instanceof Property) {
            return this.getName().equals(((Property)object).getName());
        }
        return false;
    }

    @Override
    public String getLabel() {
        return this.getName().getLabel();
    }

    public String getShortLabel() {
        String string = this.getName().getLabel();
        int n = string.indexOf(".");
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Override
    public void setValue(Object object) {
        this.m_PropertyImplementor.setPropertyValue(this.m_Index, object);
    }

    @Override
    public Object getValue() {
        return this.m_PropertyImplementor.getPropertyValue(this.m_Index);
    }

    @Override
    public PropertyType getType() {
        return this.m_PropertyImplementor.getPropertyType(this.m_Index);
    }

    public boolean isLocalPropertyValue() {
        return this.m_PropertyImplementor.isLocalPropertyValue(this.m_Index);
    }

    @Override
    public boolean isEditable() {
        return this.m_PropertyImplementor.isPropertyEditable(this.m_Index);
    }

    public int getIndex() {
        return this.m_Index;
    }
}

