/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.property;

import com.elixirtech.i18n.Name;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyHolder;
import com.elixirtech.property.PropertyNode;
import com.elixirtech.property.PropertyType;
import java.util.Iterator;
import java.util.List;

public class PropertyComposite
extends PropertyNode {
    private final Property m_Property;
    private final List<? extends PropertyHolder> m_Holders;

    public PropertyComposite(Property property, List<? extends PropertyHolder> list) {
        this.m_Property = property;
        this.m_Holders = list;
    }

    @Override
    public Name getName() {
        return this.m_Property.getName();
    }

    @Override
    public String getLabel() {
        return this.getName().getLabel();
    }

    public String getShortLabel() {
        String string = this.getName().getLabel();
        int n = string.indexOf(".");
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    @Override
    public void setValue(Object object) {
        Name name = this.m_Property.getName();
        for (PropertyHolder propertyHolder : this.m_Holders) {
            propertyHolder.getProperty(name).setValue(object);
        }
    }

    @Override
    public Object getValue() {
        Name name = this.m_Property.getName();
        Iterator<? extends PropertyHolder> iterator = this.m_Holders.iterator();
        if (iterator.hasNext()) {
            Object object = iterator.next().getProperty(name).getValue();
            while (iterator.hasNext()) {
                PropertyHolder propertyHolder = iterator.next();
                if (this.equals(propertyHolder.getProperty(name).getValue(), object)) continue;
                return null;
            }
            return object;
        }
        return null;
    }

    @Override
    public PropertyType getType() {
        return this.m_Property.getType();
    }

    @Override
    public boolean isEditable() {
        Name name = this.m_Property.getName();
        for (PropertyHolder propertyHolder : this.m_Holders) {
            Property property = propertyHolder.getProperty(name);
            if (property.isEditable()) continue;
            return false;
        }
        return true;
    }

    private boolean equals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }
}

