/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.data;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IAdaptable;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.GroupNode;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.report2.data.IDataCache;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractDataCache
implements IDataSource,
IDataCache {
    protected String m_Name;
    protected DataTable m_Table;
    protected DataSchema m_Schema;
    protected int m_RecordIndex;
    protected boolean m_HasParameters;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(AbstractDataCache.class);

    public AbstractDataCache(String string) throws DataException {
        this.m_Name = string;
        this.reset(null);
    }

    public AbstractDataCache(String string, Map<String, String> map) throws DataException {
        this.m_Name = string;
        this.reset(map);
    }

    public AbstractDataCache(String string, DataTable dataTable) {
        this.m_Name = string;
        this.m_Table = dataTable;
        this.m_Schema = this.m_Table.getSchema();
    }

    @Override
    public abstract void reset(Map<String, String> var1) throws DataException;

    @Override
    public abstract IDataCache filter(String var1, Object var2);

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IAdaptable.class) {
            return clazz.cast(this);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getDescription() {
        return this.m_Table.getDescription();
    }

    @Override
    public List<Parameter> getParameters() {
        return Collections.emptyList();
    }

    @Override
    public DataSchema getSchema() {
        return this.m_Table.getSchema();
    }

    @Override
    public String getType() {
        return this.m_Table.getType();
    }

    @Override
    public GroupNode getGroup() {
        return this.m_Table.getGroups();
    }

    @Override
    public DataTable getDataTable() {
        return this.m_Table;
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        this.m_Table.pushTo(pushContext, dataListener);
    }

    @Override
    public void reset() throws DataException {
        this.reset(null);
    }

    @Override
    public boolean hasParameters() {
        return this.m_HasParameters;
    }

    @Override
    public int getRecordIndex() {
        return this.m_RecordIndex;
    }

    @Override
    public int getRecordCount() {
        if (this.m_Table == null) {
            return 0;
        }
        return this.m_Table.getRecordCount();
    }

    @Override
    public boolean hasNext() {
        return this.m_RecordIndex >= 0 && this.m_RecordIndex < this.m_Table.getRecordCount();
    }

    @Override
    public void next() {
        if (this.hasNext()) {
            ++this.m_RecordIndex;
        }
    }

    @Override
    public boolean isGroupStart() {
        GroupNode groupNode = this.m_Table.getGroups();
        return this.isGroupStart(groupNode);
    }

    private boolean isGroupStart(GroupNode groupNode) {
        int n = groupNode.getStart();
        if (n == this.m_RecordIndex) {
            return true;
        }
        if (n > this.m_RecordIndex) {
            return false;
        }
        int n2 = groupNode.getStop();
        if (n2 < this.m_RecordIndex) {
            return false;
        }
        if (groupNode.hasChildren()) {
            Iterator<GroupNode> iterator = groupNode.getChildIterator();
            while (iterator.hasNext()) {
                boolean bl = this.isGroupStart(iterator.next());
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return this.m_Schema.getColumnName(n);
    }

    @Override
    public int getColumnIndex(String string) {
        return this.m_Schema.getColumnIndex(string);
    }

    @Override
    public Object[] getUniqueValues(String string) {
        return this.m_Table.getUniqueValues(string);
    }

    @Override
    public Object getObject(int n, String string) {
        try {
            DataRecord dataRecord = this.m_Table.getRecord(n);
            return dataRecord.getData(this.getColumnIndex(string));
        }
        catch (Throwable throwable) {
            m_Log.error((Object)("getValue(" + n + "," + string + ") error: " + String.valueOf(throwable)));
            return null;
        }
    }

    @Override
    public Object getObject(int n, int n2) {
        try {
            DataRecord dataRecord = this.m_Table.getRecord(n);
            return dataRecord.getData(n2);
        }
        catch (Throwable throwable) {
            m_Log.error((Object)("getValue(" + n + "," + n2 + ") error: " + String.valueOf(throwable)));
            return null;
        }
    }

    @Override
    public void moveToRow(int n) {
        if (n < 0) {
            n = 0;
        }
        this.m_RecordIndex = n = Math.min(n, this.getRecordCount() - 1);
    }

    @Override
    public DataRecord getRecord() {
        return this.m_Table.getRecord(this.m_RecordIndex);
    }

    @Override
    public Object getObject(String string) {
        try {
            int n = this.getColumnIndex(string);
            return this.m_Table.getRecord(this.m_RecordIndex).getData(n);
        }
        catch (Throwable throwable) {
            m_Log.error((Object)("getObject(" + string + ") error: " + String.valueOf(throwable)));
            return null;
        }
    }

    @Override
    public String getString(String string) {
        try {
            int n = this.getColumnIndex(string);
            Object object = this.m_Table.getRecord(this.m_RecordIndex).getData(n);
            DataType dataType = this.m_Schema.getColumnType(n);
            return this.m_Schema.format(dataType, object);
        }
        catch (Throwable throwable) {
            m_Log.error((Object)("getString(" + string + ") error: " + String.valueOf(throwable)));
            return null;
        }
    }

    @Override
    public int seekTo(String string, Object object) {
        try {
            int n = this.getColumnIndex(string);
            this.m_RecordIndex = this.m_Table.seek(0, n, object);
            return this.m_RecordIndex;
        }
        catch (Throwable throwable) {
            m_Log.error((Object)("seekTo(" + string + "," + String.valueOf(object) + ") error: " + String.valueOf(throwable)));
            return -1;
        }
    }

    @Override
    public Object lookup(String string, Object object, String string2) {
        try {
            return this.m_Table.lookup(string, object, string2);
        }
        catch (DataException dataException) {
            m_Log.warn((Object)("Can't lookup(" + string + "," + String.valueOf(object) + "," + string2 + "): " + String.valueOf(dataException)), (Throwable)dataException);
            return null;
        }
    }
}

