/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.MimeTypes;
import com.elixirtech.glint.GraphicsCodes;
import com.elixirtech.report2.engine.AbstractPipeline;
import com.elixirtech.report2.engine.GlintModelPageListener;
import com.elixirtech.report2.engine.GlintStreamPageListener;
import com.elixirtech.report2.engine.LogicalRendererEngine;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PagedLogicalRendererEngine;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.engine.Source;
import com.elixirtech.report2.engine.StreamedLogicalRendererEngine;
import com.elixirtech.report2.physical.glint.GlintFactory;
import com.elixirtech.report2.raw.model.RenderDetails;

public class GlintPipeline
extends AbstractPipeline
implements GraphicsCodes {
    public static final GlintFactory FACTORY = new GlintFactory();
    protected LogicalRendererEngine m_LogicalRenderer;
    protected LogicalRendererEngine m_StreamedRenderer;

    public GlintPipeline() {
        this.initFeature("DefaultFileExtension", ".glint");
        this.m_LogicalRenderer = new PagedLogicalRendererEngine();
        this.m_StreamedRenderer = new StreamedLogicalRendererEngine();
    }

    public boolean isPaged(RenderDetails renderDetails) {
        if (renderDetails == null) {
            return true;
        }
        return "Yes".equals(renderDetails.getParameterValue("Paged", "Yes"));
    }

    @Override
    public LogicalRendererEngine getLogicalRendererEngine(Source source) {
        RenderDetails renderDetails = source.getRawReport().getRenderDetails(MimeTypes.GLINT().value());
        if (this.isPaged(renderDetails)) {
            return this.m_LogicalRenderer;
        }
        return this.m_StreamedRenderer;
    }

    @Override
    public PageListener getPageListener(Result result) {
        String string = result.getFeature("Result.Type");
        if ("Result.Stream".equals(string)) {
            return new GlintStreamPageListener(result);
        }
        return new GlintModelPageListener(result);
    }

    @Override
    public void dispose() {
        this.m_LogicalRenderer = null;
        this.m_StreamedRenderer = null;
        super.dispose();
    }
}

