/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.EyeRenderer;
import com.elixirtech.report2.engine.GlintRenderer;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.logical.model.Body;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalElementHolder;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageHeader;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.RenderDetails;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public class GlintStreamPageListener
implements PageListener {
    private boolean m_Initialised;
    private PageSource m_PageSource;
    private Result m_Result;
    private OutputStream m_OutputStream;
    private EyeRenderer m_Renderer;
    private boolean m_Paged;
    private boolean m_FillBackground;

    public GlintStreamPageListener(Result result) {
        this.m_Result = result;
    }

    @Override
    public void startReport(PageSource pageSource) {
        this.m_PageSource = pageSource;
    }

    private void init() throws RenderException {
        this.m_Initialised = true;
        try {
            RenderDetails renderDetails = this.m_PageSource.getRenderDetails();
            this.m_Paged = GlintStreamPageListener.isPaged(renderDetails);
            this.m_FillBackground = GlintStreamPageListener.isFillBackground(renderDetails);
            this.m_OutputStream = this.m_Result.getOutputStream();
            this.m_Renderer = new GlintRenderer(this.m_OutputStream, true);
            this.m_Renderer.startReport(this.m_PageSource);
        }
        catch (IOException iOException) {
            throw new RenderException("Can't open output stream: " + String.valueOf(iOException), iOException);
        }
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
        if (!this.m_Initialised) {
            this.init();
        }
        this.m_Renderer.startPageSequence(pageSequence);
    }

    @Override
    public void addPage(Page page) throws RenderException {
        if (!this.m_Paged) {
            GlintStreamPageListener.adjustHeight(page);
        }
        PageSetup pageSetup = page.getPageSetup();
        int n = pageSetup.getHorizontalPageCount();
        for (int i = 0; i < n; ++i) {
            this.m_Renderer.renderPage(page, i, this.m_FillBackground);
        }
    }

    @Override
    public void endPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void endReport(PageSource pageSource) throws RenderException {
        if (this.m_Initialised && this.m_Renderer != null && this.m_OutputStream != null) {
            try {
                this.m_Renderer.endReport(pageSource);
                this.m_OutputStream.close();
            }
            catch (IOException iOException) {
                throw new RenderException("Can't close output stream: " + String.valueOf(iOException), iOException);
            }
            this.m_Result = null;
            this.m_Renderer = null;
            this.m_OutputStream = null;
        }
    }

    public static boolean isPaged(RenderDetails renderDetails) {
        if (renderDetails == null) {
            return true;
        }
        return "Yes".equals(renderDetails.getParameterValue("Paged", "Yes"));
    }

    public static boolean isFillBackground(RenderDetails renderDetails) {
        if (renderDetails == null) {
            return true;
        }
        return "Yes".equals(renderDetails.getParameterValue("FillBackground", "Yes"));
    }

    public static void adjustHeight(Page page) {
        LogicalElementHolder logicalElementHolder;
        PageSetup pageSetup = page.getPageSetup();
        int n = 0;
        int n2 = pageSetup.getTop();
        PageHeader pageHeader = page.getPageHeader();
        if (pageHeader != null) {
            n = Math.max(n, GlintStreamPageListener.getWidth(pageHeader));
            n2 += pageHeader.getHeight();
        }
        Body body = page.getBody();
        Iterator<BodyPart> iterator = body.getBodyPartIterator();
        while (iterator.hasNext()) {
            logicalElementHolder = iterator.next();
            n = Math.max(n, GlintStreamPageListener.getWidth(logicalElementHolder));
            n2 += logicalElementHolder.getHeight();
        }
        logicalElementHolder = page.getPageFooter();
        if (logicalElementHolder != null) {
            n = Math.max(n, GlintStreamPageListener.getWidth(logicalElementHolder));
            n2 += logicalElementHolder.getHeight();
        }
        pageSetup.setWidth(n += pageSetup.getLeft() + pageSetup.getRight());
        pageSetup.setHeight(n2 += pageSetup.getBottom());
    }

    private static int getWidth(LogicalElementHolder logicalElementHolder) {
        int n = 0;
        Iterator<LogicalElement> iterator = logicalElementHolder.getLogicalElementIterator();
        while (iterator.hasNext()) {
            LogicalElement logicalElement = iterator.next();
            n = Math.max(n, logicalElement.getLeft() + logicalElement.getWidth());
        }
        return n;
    }
}

