/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.html.HTMLGenerator;
import com.elixirtech.report2.html.HTMLNavigator;
import com.elixirtech.report2.html.HTMLOutputter;
import com.elixirtech.report2.html.StreamedHTMLGenerator;
import com.elixirtech.report2.html.TreeHTMLNavigator;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.raw.model.RenderDetails;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class HTMLPageListener
implements PageListener {
    private Result m_Result;
    private HTMLGenerator m_Generator;
    private ZipOutputStream m_Zip;

    public HTMLPageListener(Result result) {
        this.m_Result = result;
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        RenderDetails renderDetails = pageSource.getRenderDetails();
        boolean bl = renderDetails.isSet("SVGPassThrough");
        boolean bl2 = renderDetails.isSet("EmbeddedPageLinks");
        this.m_Generator = this.getGenerator(pageSource);
        this.m_Generator.setSVGPassThrough(bl);
        this.m_Generator.setEmbeddedPageLinks(bl2);
        try {
            this.m_Zip = new ZipOutputStream(this.m_Result.getOutputStream());
            ZipEntry zipEntry = new ZipEntry("report.txt");
            this.m_Zip.putNextEntry(zipEntry);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            outputStreamWriter.append("Generated by Elixir Repertoire");
            outputStreamWriter.flush();
            this.m_Zip.write(byteArrayOutputStream.toByteArray());
            this.m_Zip.closeEntry();
        }
        catch (IOException iOException) {
            throw new RenderException("Error opening output stream: " + String.valueOf(iOException), iOException);
        }
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
        this.m_Generator.startPageSequence(pageSequence);
    }

    @Override
    public void addPage(Page page) throws RenderException {
        try {
            this.m_Generator.renderPage(page, this.m_Zip);
        }
        catch (IOException iOException) {
            throw new RenderException("Error writing page: " + String.valueOf(iOException), iOException);
        }
    }

    @Override
    public void endPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void endReport(PageSource pageSource) throws RenderException {
        try {
            this.m_Generator.endReport();
            this.m_Generator.renderExtras(this.m_Zip);
            this.m_Zip.flush();
            this.m_Zip.close();
        }
        catch (IOException iOException) {
            throw new RenderException("Error closing stream: " + String.valueOf(iOException), iOException);
        }
        this.m_Generator = null;
        this.m_Result = null;
        this.m_Zip = null;
    }

    protected HTMLGenerator getGenerator(PageSource pageSource) {
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        RenderDetails renderDetails = pageSource.getRenderDetails();
        bl = renderDetails.isSet("SkipHeaders");
        bl2 = renderDetails.isSet("Paged") || renderDetails.isSet("PageDiv");
        bl3 = renderDetails.isSet("Streamed");
        bl4 = renderDetails.isSet("Tree");
        String string = renderDetails.getParameterValue("ExtraHeaders", "");
        HTMLGenerator hTMLGenerator = null;
        HTMLOutputter hTMLOutputter = new HTMLOutputter(bl);
        if (!bl && StringUtil.notEmpty(string)) {
            hTMLOutputter.addHeaders(string);
        }
        String string2 = renderDetails.getParameterValue("BaseURL", null);
        hTMLOutputter.setBaseURL(string2);
        hTMLGenerator = bl3 ? new StreamedHTMLGenerator(pageSource.getLogicalReport(), hTMLOutputter) : (bl4 ? new HTMLGenerator(pageSource.getLogicalReport(), hTMLOutputter, new TreeHTMLNavigator()) : new HTMLGenerator(pageSource.getLogicalReport(), hTMLOutputter, new HTMLNavigator()));
        hTMLGenerator.setBackgroundDiv(bl2);
        if (renderDetails.isSet("Tree")) {
            String string3 = renderDetails.getParameterValue("TreeHighlightColor");
            String string4 = renderDetails.getParameterValue("TreeNormalColor");
            if (string3 != null && string4 != null) {
                hTMLGenerator.setBackground(string3, string4);
            }
        }
        return hTMLGenerator;
    }
}

