/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.MimeTypes;
import com.elixirtech.report2.engine.AbstractPipeline;
import com.elixirtech.report2.engine.HTMLPageListener;
import com.elixirtech.report2.engine.LogicalRendererEngine;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PagedLogicalRendererEngine;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.engine.SectionedLogicalRendererEngine;
import com.elixirtech.report2.engine.Source;
import com.elixirtech.report2.engine.StreamedLogicalRendererEngine;
import com.elixirtech.report2.engine.TreeLogicalRendererEngine;
import com.elixirtech.report2.raw.model.RenderDetails;

public class HTMLZipPipeline
extends AbstractPipeline {
    private LogicalRendererEngine m_StreamedLogicalRenderer;
    private LogicalRendererEngine m_SectionedLogicalRenderer;
    private LogicalRendererEngine m_PagedLogicalRenderer;
    private LogicalRendererEngine m_TreeLogicalRenderer;

    public HTMLZipPipeline() {
        this.initFeature("DefaultFileExtension", ".html.zip");
        this.m_StreamedLogicalRenderer = new StreamedLogicalRendererEngine();
        this.m_SectionedLogicalRenderer = new SectionedLogicalRendererEngine();
        this.m_PagedLogicalRenderer = new PagedLogicalRendererEngine();
        this.m_TreeLogicalRenderer = new TreeLogicalRendererEngine();
    }

    public MimeType getMimeType() {
        return MimeTypes.HTML_ZIP();
    }

    @Override
    public LogicalRendererEngine getLogicalRendererEngine(Source source) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        RenderDetails renderDetails = source.getRawReport().getRenderDetails(this.getMimeType().value());
        if (renderDetails != null) {
            bl = renderDetails.isSet("Paged");
        }
        if (bl) {
            return this.m_PagedLogicalRenderer;
        }
        if (renderDetails != null) {
            bl2 = renderDetails.isSet("Sectioned");
        }
        if (bl2) {
            return this.m_SectionedLogicalRenderer;
        }
        if (renderDetails != null) {
            bl3 = renderDetails.isSet("Tree");
        }
        if (bl3) {
            return this.m_TreeLogicalRenderer;
        }
        return this.m_StreamedLogicalRenderer;
    }

    @Override
    public PageListener getPageListener(Result result) {
        return new HTMLPageListener(result);
    }

    @Override
    public void dispose() {
        this.m_StreamedLogicalRenderer = null;
        this.m_SectionedLogicalRenderer = null;
        this.m_PagedLogicalRenderer = null;
        this.m_TreeLogicalRenderer = null;
        super.dispose();
    }
}

