/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.JDOMException;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.report2.engine.PCLFont;
import com.elixirtech.report2.engine.PCLStream;
import com.elixirtech.util.VariableSubstitution;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class PCLConfig
implements VariableSubstitution.ICallback {
    public static final String CONFIG = "pcl.xml";
    private Map<String, String> m_Properties;
    private Map<Integer, PCLFont> m_Fonts;
    private Map<String, Mapping> m_Mapping;
    private int m_Default;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(PCLConfig.class);

    public PCLConfig() throws JDOMException, IOException {
        String string;
        Object object;
        Object object3;
        Element element32;
        InputStream inputStream = this.getConfigStream();
        Document document = new SAXBuilder().build(inputStream);
        Element element2 = document.getRootElement();
        this.m_Properties = new HashMap<String, String>();
        for (Element element32 : element2.getChildren("property")) {
            object3 = element32.getAttributeValue("name");
            String object22 = element32.getText();
            if (object3 == null || object22 == null) continue;
            this.m_Properties.put((String)object3, object22);
        }
        VariableSubstitution variableSubstitution = new VariableSubstitution(this);
        this.m_Fonts = new HashMap<Integer, PCLFont>();
        element32 = element2.getChild("fonts");
        for (Element element : element32.getChildren("font")) {
            String string2 = variableSubstitution.substitute(element.getAttributeValue("id"));
            object = variableSubstitution.substitute(element.getAttributeValue("typeface"));
            string = variableSubstitution.substitute(element.getAttributeValue("symbols"));
            String string3 = variableSubstitution.substitute(element.getAttributeValue("fixed"));
            String string4 = variableSubstitution.substitute(element.getAttributeValue("condensed"));
            try {
                Element element4;
                PCLFont pCLFont = new PCLFont();
                Integer n = new Integer(string2);
                pCLFont.setId(n);
                if (object != null) {
                    pCLFont.setTypeFace(new Integer((String)object));
                }
                if (string != null) {
                    pCLFont.setSymbols(string);
                }
                if (string3 != null) {
                    pCLFont.setFixed("Yes".equalsIgnoreCase(string3));
                }
                if (string4 != null) {
                    pCLFont.setCondensed("Yes".equalsIgnoreCase(string4));
                }
                if ((element4 = element.getChild("header")) != null) {
                    pCLFont.setHeader(variableSubstitution.substitute(element4.getText()));
                }
                for (Element element5 : element.getChildren("bytes")) {
                    pCLFont.addBytes(variableSubstitution.substitute(element5.getText()));
                }
                this.m_Fonts.put(n, pCLFont);
            }
            catch (NumberFormatException numberFormatException) {
                m_Log.error((Object)("Error parsing integer, id=" + string2 + " typeface=" + (String)object));
            }
        }
        this.m_Mapping = new HashMap<String, Mapping>();
        element32 = element2.getChild("font-mapping");
        object3 = element32.getChild("default");
        if (object3 != null) {
            String string5 = variableSubstitution.substitute(((Element)object3).getAttributeValue("select"));
            try {
                this.m_Default = Integer.parseInt(string5);
            }
            catch (NumberFormatException numberFormatException) {
                m_Log.error((Object)("Can't interpret default " + string5 + " as an integer"));
            }
        }
        for (Element element : element32.getChildren("map")) {
            object = new Mapping();
            ((Mapping)object).name = variableSubstitution.substitute(element.getAttributeValue("name"));
            string = variableSubstitution.substitute(element.getAttributeValue("font"));
            try {
                ((Mapping)object).font = Integer.parseInt(string);
                this.m_Mapping.put(((Mapping)object).name, (Mapping)object);
            }
            catch (NumberFormatException numberFormatException) {
                m_Log.error((Object)("Can't interpret font " + string + " as an integer"));
            }
        }
    }

    public int getFontId(String string) {
        Mapping mapping = this.m_Mapping.get(string);
        if (mapping == null) {
            return this.m_Default;
        }
        return mapping.font;
    }

    public void writeHeader(Integer n, PCLStream pCLStream) {
        PCLFont pCLFont = this.m_Fonts.get(n);
        if (pCLFont != null) {
            pCLFont.writeHeader(pCLStream);
        }
    }

    public void writeBytes(Integer n, PCLStream pCLStream) {
        PCLFont pCLFont = this.m_Fonts.get(n);
        if (pCLFont != null) {
            pCLFont.writeBytes(pCLStream);
        }
    }

    public void selectFont(Integer n, String string, boolean bl, boolean bl2, PCLStream pCLStream) {
        PCLFont pCLFont = this.m_Fonts.get(n);
        if (pCLFont != null) {
            pCLFont.selectFont(pCLStream, string, bl, bl2);
        }
    }

    private InputStream getConfigStream() {
        m_Log.info((Object)"Reading from within jar/war archive, config/pcl.xml");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResourceAsStream("config/pcl.xml");
    }

    @Override
    public String getValue(String string) {
        if (this.m_Properties.containsKey(string)) {
            return this.m_Properties.get(string);
        }
        return System.getProperty(string);
    }

    private static class Mapping {
        String name;
        int font;

        private Mapping() {
        }
    }
}

