/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.PCLRenderer;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.raw.model.PageSetup;
import java.io.IOException;
import java.io.OutputStream;

public class PCLPageListener
implements PageListener {
    private Result m_Result;
    private PageSource m_PageSource;
    private PCLRenderer m_Renderer;
    private OutputStream m_Out;

    public PCLPageListener(Result result) {
        this.m_Result = result;
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        this.m_PageSource = pageSource;
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void addPage(Page page) throws RenderException {
        this.lazyStart();
        PageSetup pageSetup = page.getPageSetup();
        int n = pageSetup.getHorizontalPageCount();
        for (int i = 0; i < n; ++i) {
            this.m_Renderer.renderPage(page, i);
        }
    }

    @Override
    public void endPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void endReport(PageSource pageSource) throws RenderException {
        this.lazyStart();
        try {
            this.m_Renderer.close();
            this.m_Out.close();
        }
        catch (IOException iOException) {
            throw new RenderException("Can't close stream: " + String.valueOf(iOException), iOException);
        }
        this.m_Result = null;
        this.m_Renderer = null;
        this.m_Out = null;
    }

    private void lazyStart() {
        if (this.m_Out == null) {
            try {
                this.m_Out = this.m_Result.getOutputStream();
                this.m_Renderer = new PCLRenderer(this.m_Out);
                this.m_Renderer.startReport(this.m_PageSource);
            }
            catch (IOException iOException) {
                throw new RenderException("Can't open stream: " + String.valueOf(iOException), iOException);
            }
        }
    }
}

