/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.MimeTypes;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.glint.Color;
import com.elixirtech.glint.ColorManager;
import com.elixirtech.glint.GlintRenderContext;
import com.elixirtech.glint.GraphicsCodes;
import com.elixirtech.glint.IGlint;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.GlintPCL;
import com.elixirtech.report2.engine.PCLConfig;
import com.elixirtech.report2.engine.PCLPipeline;
import com.elixirtech.report2.engine.PCLStream;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.logical.model.Body;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.Column;
import com.elixirtech.report2.logical.model.Columns;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalElementHolder;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageFooter;
import com.elixirtech.report2.logical.model.PageHeader;
import com.elixirtech.report2.physical.PhysicalRenderer;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.RenderDetails;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;

public class PCLRenderer
extends PhysicalRenderer
implements GraphicsCodes {
    protected GlintPCL m_Glint;
    protected PCLStream m_PCLStream;
    protected OutputStream m_OutputStream;
    private int m_OffsetX;
    private int m_OffsetY;
    private static PCLConfig m_Config;

    public PCLRenderer(OutputStream outputStream) throws RenderException {
        super(PCLPipeline.FACTORY);
        this.m_OutputStream = outputStream;
        if (m_Config == null) {
            try {
                m_Config = new PCLConfig();
            }
            catch (Throwable throwable) {
                throw new RenderException("Error loading PCLConfig", throwable);
            }
        }
    }

    public void close() throws IOException {
        GlintPCL.endOutput(this.m_PCLStream);
        this.m_Glint.flush();
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        this.m_OffsetX = 0;
        this.m_OffsetY = 0;
        int n = 0;
        RenderDetails renderDetails = pageSource.getRenderDetails();
        String string = renderDetails.getParameterValue("OffsetX");
        String string2 = renderDetails.getParameterValue("OffsetY");
        String string3 = renderDetails.getParameterValue("Sides");
        if (StringUtil.notEmpty(string)) {
            this.m_OffsetX = Integer.parseInt(string);
        }
        if (StringUtil.notEmpty(string2)) {
            this.m_OffsetY = Integer.parseInt(string2);
        }
        if ("TwoSidedLongEdge".equals(string3)) {
            n = 1;
        } else if ("TwoSidedShortEdge".equals(string3)) {
            n = 2;
        }
        this.m_PCLStream = new PCLStream(this.m_OutputStream);
        GlintPCL.startOutput(this.m_PCLStream);
        this.m_Glint = new GlintPCL(m_Config, this.m_PCLStream, n);
        super.startReport(pageSource);
    }

    public MimeType getMimeType() {
        return MimeTypes.PCL();
    }

    public void renderPage(Page page, int n) {
        GlintRenderContext glintRenderContext = new GlintRenderContext((PhysicalRenderer)this, n + 1, page, this.m_Glint, (Map<String, Object>)this.m_Cache, false);
        this.m_Glint.setPCLOffset(this.m_OffsetX, this.m_OffsetY);
        this.renderPage(glintRenderContext, page);
        glintRenderContext.dispose();
    }

    public void renderPage(GlintRenderContext glintRenderContext, Page page) {
        int n = 0;
        IGlint iGlint = glintRenderContext.getGlint();
        PageSetup pageSetup = page.getPageSetup();
        int n2 = pageSetup.getLeft();
        int n3 = pageSetup.getTop();
        int n4 = pageSetup.getWidth() - pageSetup.getLeft() - pageSetup.getRight();
        int n5 = pageSetup.getHeight() - pageSetup.getTop() - pageSetup.getBottom();
        iGlint.pushClip(n2 + glintRenderContext.getHShift(), n3, n4, n5);
        Page page2 = page.getWatermark();
        if (page2 != null) {
            this.renderPage(glintRenderContext, page2);
        }
        iGlint.offsetOrigin(n2, n3);
        PageHeader pageHeader = page.getPageHeader();
        if (pageHeader != null) {
            this.renderChunk2(glintRenderContext, (LogicalElementHolder)pageHeader);
            n = pageHeader.getHeight();
            iGlint.offsetOrigin(0, n);
        }
        Body body = page.getBody();
        GlintTranslator glintTranslator = new GlintTranslator(glintRenderContext);
        this.renderBody(glintRenderContext, body, glintTranslator);
        glintTranslator.revert();
        iGlint.offsetOrigin(0, -n);
        PageFooter pageFooter = page.getPageFooter();
        if (pageFooter != null) {
            int n6 = pageFooter.getHeight();
            int n7 = pageSetup.getHeight() - pageSetup.getTop() - pageSetup.getBottom() - n6;
            iGlint.offsetOrigin(0, n7);
            this.renderChunk2(glintRenderContext, (LogicalElementHolder)pageFooter);
            iGlint.offsetOrigin(0, -n7);
        }
        iGlint.offsetOrigin(-n2, -n3);
        iGlint.popClip();
    }

    protected void renderBody(GlintRenderContext glintRenderContext, Body body, GlintTranslator glintTranslator) {
        for (BodyPart bodyPart : body.getBodyPartList()) {
            if (bodyPart instanceof Columns) {
                this.renderColumns(glintRenderContext, (Columns)bodyPart, glintTranslator);
                continue;
            }
            this.renderChunk2(glintRenderContext, (LogicalElementHolder)bodyPart);
            int n = bodyPart.getHeight();
            int n2 = bodyPart.getSpaceAfter();
            glintTranslator.translate(0, n + n2);
        }
    }

    protected void renderColumns(GlintRenderContext glintRenderContext, Columns columns, GlintTranslator glintTranslator) {
        int n = 0;
        GlintTranslator glintTranslator2 = new GlintTranslator(glintRenderContext);
        Iterator<Column> iterator = columns.getColumnIterator();
        while (iterator.hasNext()) {
            Column column = iterator.next();
            this.renderColumn(glintRenderContext, column, glintTranslator2);
            n = Math.max(n, glintTranslator2.getY());
            if (!iterator.hasNext()) continue;
            int n2 = column.getWidth();
            int n3 = column.getSpaceAfter();
            glintTranslator2.revertY();
            glintTranslator2.translate(n2 + n3, 0);
        }
        glintTranslator2.revert();
        glintTranslator.translate(0, n);
    }

    protected void renderColumn(GlintRenderContext glintRenderContext, Column column, GlintTranslator glintTranslator) {
        for (BodyPart bodyPart : column.getBodyPartList()) {
            this.renderChunk2(glintRenderContext, (LogicalElementHolder)bodyPart);
            int n = bodyPart.getHeight();
            int n2 = bodyPart.getSpaceAfter();
            glintTranslator.translate(0, n + n2);
        }
    }

    protected void renderChunk2(GlintRenderContext glintRenderContext, LogicalElementHolder logicalElementHolder) {
        String string = logicalElementHolder.getBackgroundColor();
        if (StringUtil.notEmpty(string)) {
            Color color = ColorManager.lookup(string);
            IGlint object = glintRenderContext.getGlint();
            IGlint.ColorId colorId = object.defineColor(color);
            IGlint.PenId penId = new IGlint.PenId(0);
            object.drawRect(penId, colorId, 0, 0, logicalElementHolder.getWidth(), logicalElementHolder.getHeight());
        }
        for (LogicalElement logicalElement : logicalElementHolder.getLogicalElementList()) {
            this.render2(glintRenderContext, logicalElement);
        }
    }

    protected void render2(GlintRenderContext glintRenderContext, LogicalElement logicalElement) {
        String string = logicalElement.getTagName();
        try {
            Object object;
            Object object2;
            Object object3 = logicalElement.getProperty("PCL.InsertBefore");
            if (object3 != null) {
                this.passThrough(object3);
            }
            if ((object2 = logicalElement.getProperty("PCL.InsertInstead")) != null) {
                this.passThrough(object2);
            } else {
                object = this.m_PhysicalRendererFactory.getRenderer(string);
                if (object != null) {
                    object.render(glintRenderContext, logicalElement);
                }
            }
            object = logicalElement.getProperty("PCL.InsertAfter");
            if (object != null) {
                this.passThrough(object);
            }
        }
        catch (RenderException renderException) {
            System.out.println(renderException.toString());
        }
    }

    private void passThrough(Object object) {
        if (object instanceof String) {
            this.m_PCLStream.add((String)object);
        } else if (object instanceof byte[]) {
            this.m_PCLStream.add((byte[])object);
        }
    }

    protected static class GlintTranslator {
        private GlintRenderContext m_Context;
        private int m_X;
        private int m_Y;

        public GlintTranslator(GlintRenderContext glintRenderContext) {
            this.m_Context = glintRenderContext;
        }

        public void translate(int n, int n2) {
            this.m_X += n;
            this.m_Y += n2;
            this.m_Context.getGlint().offsetOrigin(n, n2);
        }

        public void revert() {
            this.m_Context.getGlint().offsetOrigin(-this.m_X, -this.m_Y);
            this.m_X = 0;
            this.m_Y = 0;
        }

        public void revertY() {
            this.m_Context.getGlint().offsetOrigin(0, -this.m_Y);
            this.m_Y = 0;
        }

        public int getY() {
            return this.m_Y;
        }
    }
}

