/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.print.PrintAttribute;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.Parameter;
import com.elixirtech.report2.raw.model.RenderDetails;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;

public class PrinterUtil {
    private static final String[] MediaSizeNameStrings = new String[]{"iso-a0", "iso-a1", "iso-a2", "iso-a3", "iso-a4", "iso-a5", "iso-a6", "iso-a7", "iso-a8", "iso-a9", "iso-a10", "iso-b0", "iso-b1", "iso-b2", "iso-b3", "iso-b4", "iso-b5", "iso-b6", "iso-b7", "iso-b8", "iso-b9", "iso-b10", "jis-b0", "jis-b1", "jis-b2", "jis-b3", "jis-b4", "jis-b5", "jis-b6", "jis-b7", "jis-b8", "jis-b9", "jis-b10", "iso-c0", "iso-c1", "iso-c2", "iso-c3", "iso-c4", "iso-c5", "iso-c6", "na-letter", "na-legal", "executive", "ledger", "tabloid", "invoice", "folio", "quarto", "japanese-postcard", "oufuko-postcard", "a", "b", "c", "d", "e", "iso-designated-long", "italian-envelope", "monarch-envelope", "personal-envelope", "na-number-9-envelope", "na-number-10-envelope", "na-number-11-envelope", "na-number-12-envelope", "na-number-14-envelope", "na-6x9-envelope", "na-7x9-envelope", "na-9x11-envelope", "na-9x12-envelope", "na-10x13-envelope", "na-10x14-envelope", "na-10x15-envelope", "na-5x7", "na-8x10"};
    private static final MediaSizeName[] MediaSizeNameValues = new MediaSizeName[]{MediaSizeName.ISO_A0, MediaSizeName.ISO_A1, MediaSizeName.ISO_A2, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.ISO_A6, MediaSizeName.ISO_A7, MediaSizeName.ISO_A8, MediaSizeName.ISO_A9, MediaSizeName.ISO_A10, MediaSizeName.ISO_B0, MediaSizeName.ISO_B1, MediaSizeName.ISO_B2, MediaSizeName.ISO_B3, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5, MediaSizeName.ISO_B6, MediaSizeName.ISO_B7, MediaSizeName.ISO_B8, MediaSizeName.ISO_B9, MediaSizeName.ISO_B10, MediaSizeName.JIS_B0, MediaSizeName.JIS_B1, MediaSizeName.JIS_B2, MediaSizeName.JIS_B3, MediaSizeName.JIS_B4, MediaSizeName.JIS_B5, MediaSizeName.JIS_B6, MediaSizeName.JIS_B7, MediaSizeName.JIS_B8, MediaSizeName.JIS_B9, MediaSizeName.JIS_B10, MediaSizeName.ISO_C0, MediaSizeName.ISO_C1, MediaSizeName.ISO_C2, MediaSizeName.ISO_C3, MediaSizeName.ISO_C4, MediaSizeName.ISO_C5, MediaSizeName.ISO_C6, MediaSizeName.NA_LETTER, MediaSizeName.NA_LEGAL, MediaSizeName.EXECUTIVE, MediaSizeName.LEDGER, MediaSizeName.TABLOID, MediaSizeName.INVOICE, MediaSizeName.FOLIO, MediaSizeName.QUARTO, MediaSizeName.JAPANESE_POSTCARD, MediaSizeName.JAPANESE_DOUBLE_POSTCARD, MediaSizeName.A, MediaSizeName.B, MediaSizeName.C, MediaSizeName.D, MediaSizeName.E, MediaSizeName.ISO_DESIGNATED_LONG, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.MONARCH_ENVELOPE, MediaSizeName.PERSONAL_ENVELOPE, MediaSizeName.NA_NUMBER_9_ENVELOPE, MediaSizeName.NA_NUMBER_10_ENVELOPE, MediaSizeName.NA_NUMBER_11_ENVELOPE, MediaSizeName.NA_NUMBER_12_ENVELOPE, MediaSizeName.NA_NUMBER_14_ENVELOPE, MediaSizeName.NA_6X9_ENVELOPE, MediaSizeName.NA_7X9_ENVELOPE, MediaSizeName.NA_9X11_ENVELOPE, MediaSizeName.NA_9X12_ENVELOPE, MediaSizeName.NA_10X13_ENVELOPE, MediaSizeName.NA_10X14_ENVELOPE, MediaSizeName.NA_10X15_ENVELOPE, MediaSizeName.NA_5X7, MediaSizeName.NA_8X10};
    static Map<String, MediaSizeName> MediaSizeMap = new HashMap<String, MediaSizeName>();

    public static boolean showPrintDialog(Frame frame, RenderDetails renderDetails) {
        Object object;
        Serializable serializable;
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        Iterator<Parameter> iterator = renderDetails.getParameterIterator();
        while (iterator.hasNext()) {
            serializable = iterator.next();
            object = PrintAttribute.create(((Parameter)serializable).getKey(), ((Parameter)serializable).getValue());
            if (object == null) continue;
            ((PrintAttribute)object).buildAttributeSet(hashPrintRequestAttributeSet);
        }
        serializable = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
        object = frame.getBounds();
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices((DocFlavor)serializable, null);
        PrintService printService = ServiceUI.printDialog(null, ((Rectangle)object).x + ((Rectangle)object).width / 2 - 200, ((Rectangle)object).y + ((Rectangle)object).height / 2 - 200, printServiceArray, null, (DocFlavor)serializable, hashPrintRequestAttributeSet);
        if (printService != null) {
            Attribute[] attributeArray = hashPrintRequestAttributeSet.toArray();
            for (int i = 0; i < attributeArray.length; ++i) {
                Parameter parameter = PrintAttribute.extract(attributeArray[i]);
                if (parameter == null) continue;
                renderDetails.addParameter(parameter);
            }
            return true;
        }
        return false;
    }

    public static PageFormat getPageFormat(Page page) {
        PageSetup pageSetup = page.getPageSetup();
        Paper paper = new Paper();
        PageFormat pageFormat = new PageFormat();
        if ("Landscape".equals(pageSetup.getOrientation())) {
            int n = pageSetup.getWidth() / 20;
            int n2 = pageSetup.getHeight() / 20;
            paper.setSize(n2, n);
            paper.setImageableArea(0.0, 0.0, n2, n);
            pageFormat.setOrientation(0);
        } else {
            int n = pageSetup.getWidth() / 20;
            int n3 = pageSetup.getHeight() / 20;
            paper.setSize(n, n3);
            paper.setImageableArea(0.0, 0.0, n, n3);
            pageFormat.setOrientation(1);
        }
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    public static PageFormat getScaledPageFormat(Page page, Dimension dimension) {
        assert (dimension != null);
        PageSetup pageSetup = page.getPageSetup();
        Paper paper = new Paper();
        PageFormat pageFormat = new PageFormat();
        double d = dimension.width;
        double d2 = dimension.height;
        if ("Landscape".equals(pageSetup.getOrientation())) {
            double d3 = d / (double)pageSetup.getHeight();
            double d4 = d2 / (double)pageSetup.getWidth();
            double d5 = Math.min(d3, d4);
            int n = (int)((double)pageSetup.getHeight() * d5 / 20.0);
            int n2 = (int)((double)pageSetup.getWidth() * d5 / 20.0);
            paper.setSize(n, n2);
            paper.setImageableArea(0.0, 0.0, n, n2);
            pageFormat.setOrientation(0);
        } else {
            double d6 = d / (double)pageSetup.getWidth();
            double d7 = d2 / (double)pageSetup.getHeight();
            double d8 = Math.min(d6, d7);
            int n = (int)((double)pageSetup.getWidth() * d8 / 20.0);
            int n3 = (int)((double)pageSetup.getHeight() * d8 / 20.0);
            paper.setSize(n, n3);
            paper.setImageableArea(0.0, 0.0, n, n3);
            pageFormat.setOrientation(1);
        }
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    public static String[] getMediaSizeNameStrings() {
        return MediaSizeNameStrings;
    }

    public static MediaSizeName[] getMediaSizeNameValues() {
        return MediaSizeNameValues;
    }

    public static MediaSizeName lookup(String string) {
        return MediaSizeMap.get(string);
    }

    static {
        for (int i = 0; i < MediaSizeNameStrings.length; ++i) {
            MediaSizeMap.put(MediaSizeNameStrings[i], MediaSizeNameValues[i]);
        }
    }
}

