/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.glint.Color;
import com.elixirtech.glint.Font;
import com.elixirtech.glint.GraphicsCodes;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.IResourceManager;
import com.elixirtech.glint.Image;
import com.elixirtech.glint.Pen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceManager
implements IResourceManager,
GraphicsCodes {
    private Map<String, IGlint.FontId> m_FontMap = new HashMap<String, IGlint.FontId>();
    private Map<String, IGlint.ColorId> m_ColorMap = new HashMap<String, IGlint.ColorId>();
    private Map<String, IGlint.ImageId> m_ImageMap = new HashMap<String, IGlint.ImageId>();
    private Map<String, IGlint.PenId> m_PenMap = new HashMap<String, IGlint.PenId>();
    private List<Font> m_FontList = new ArrayList<Font>();
    private List<Color> m_ColorList = new ArrayList<Color>();
    private List<Image> m_ImageList = new ArrayList<Image>();
    private List<Pen> m_PenList = new ArrayList<Pen>();
    private List<String> m_StringList = new ArrayList<String>();

    protected ResourceManager() {
        this.initConstants();
    }

    private void initConstants() {
        this.m_PenMap.put(this.getKey(Pen.NONE), new IGlint.PenId(0));
        this.m_PenList.add(Pen.NONE);
        this.m_ColorMap.put(this.getKey(Color.NONE), new IGlint.ColorId(0));
        this.m_ColorList.add(Color.NONE);
    }

    @Override
    public IGlint.FontId defineFont(Font font) {
        String string = this.getKey(font);
        IGlint.FontId fontId = this.m_FontMap.get(string);
        if (fontId == null) {
            fontId = new IGlint.FontId(this.m_FontList.size());
            this.m_FontMap.put(string, fontId);
            this.m_FontList.add(font);
        }
        return fontId;
    }

    @Override
    public IGlint.ColorId defineColor(Color color) {
        String string = this.getKey(color);
        IGlint.ColorId colorId = this.m_ColorMap.get(string);
        if (colorId == null) {
            colorId = new IGlint.ColorId(this.m_ColorList.size());
            this.m_ColorMap.put(string, colorId);
            this.m_ColorList.add(color);
        }
        return colorId;
    }

    @Override
    public IGlint.ImageId defineImage(Image image) {
        String string = this.getKey(image);
        IGlint.ImageId imageId = this.m_ImageMap.get(string);
        if (imageId == null) {
            imageId = new IGlint.ImageId(this.m_ImageList.size());
            if (string != null) {
                this.m_ImageMap.put(string, imageId);
            }
            this.m_ImageList.add(image);
        }
        return imageId;
    }

    @Override
    public IGlint.PenId definePen(Pen pen) {
        String string = this.getKey(pen);
        IGlint.PenId penId = this.m_PenMap.get(string);
        if (penId == null) {
            penId = new IGlint.PenId(this.m_PenList.size());
            this.m_PenMap.put(string, penId);
            this.m_PenList.add(pen);
        }
        return penId;
    }

    @Override
    public IGlint.StringId defineString() {
        IGlint.StringId stringId = new IGlint.StringId(this.m_StringList.size());
        this.m_StringList.add("");
        return stringId;
    }

    @Override
    public void setString(IGlint.StringId stringId, String string) {
        this.m_StringList.set(stringId.id, string);
    }

    @Override
    public Font getFont(IGlint.FontId fontId) {
        return this.m_FontList.get(fontId.id);
    }

    @Override
    public Color getColor(IGlint.ColorId colorId) {
        return this.m_ColorList.get(colorId.id);
    }

    @Override
    public Image getImage(IGlint.ImageId imageId) {
        return this.m_ImageList.get(imageId.id);
    }

    @Override
    public Pen getPen(IGlint.PenId penId) {
        return this.m_PenList.get(penId.id);
    }

    @Override
    public String getString(IGlint.StringId stringId) {
        return this.m_StringList.get(stringId.id);
    }

    @Override
    public int getFontCount() {
        return this.m_FontList.size();
    }

    @Override
    public int getColorCount() {
        return this.m_ColorList.size();
    }

    @Override
    public int getImageCount() {
        return this.m_ImageList.size();
    }

    @Override
    public int getPenCount() {
        return this.m_PenList.size();
    }

    @Override
    public int getStringCount() {
        return this.m_StringList.size();
    }

    private String getKey(Font font) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(font.getName());
        stringBuffer.append('|');
        stringBuffer.append(font.getSize());
        stringBuffer.append('|');
        stringBuffer.append(font.getStyle());
        return stringBuffer.toString();
    }

    private String getKey(Color color) {
        if (color == Color.NONE) {
            return "None";
        }
        return Integer.toString(color.getRGB());
    }

    private String getKey(Image image) {
        return image.getId();
    }

    private String getKey(Pen pen) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(pen.getColor().getRGB());
        stringBuffer.append('|');
        stringBuffer.append(pen.getWidth());
        stringBuffer.append('|');
        stringBuffer.append(pen.getStyle());
        return stringBuffer.toString();
    }
}

