/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.data2.DataException;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.ResourceProviderStack;
import com.elixirtech.report2.engine.pl.LogicalReportPageListener;
import com.elixirtech.report2.logical.AcrossThenDownStreamedSectionRenderer;
import com.elixirtech.report2.logical.DataHolder;
import com.elixirtech.report2.logical.PagedLogicalRenderContext;
import com.elixirtech.report2.logical.PagedSectionRenderer;
import com.elixirtech.report2.logical.RenderStack;
import com.elixirtech.report2.logical.StreamedRenderContext;
import com.elixirtech.report2.logical.StreamedSectionRenderer;
import com.elixirtech.report2.logical.model.LogicalReport;
import com.elixirtech.report2.raw.model.IResourceProvider;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.Section;

public class SectionEngine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogicalReport render(IResourceProvider iResourceProvider, Section section, DataHolder dataHolder) throws RenderException, DataException {
        RenderStack renderStack = RenderStack.current();
        LogicalReportPageListener logicalReportPageListener = new LogicalReportPageListener();
        StreamedRenderContext streamedRenderContext = new StreamedRenderContext(logicalReportPageListener, null);
        IResourceProvider iResourceProvider2 = section.getRawReport();
        if (iResourceProvider2 != iResourceProvider) {
            section.setRawReport(new ResourceProviderStack(iResourceProvider, iResourceProvider2));
            section.loaded();
        }
        renderStack.push(iResourceProvider2, streamedRenderContext);
        try {
            dataHolder.resolve();
            LogicalReport logicalReport = new LogicalReport();
            streamedRenderContext.startReport();
            PageSetup pageSetup = section.getRawReport().getPageSetup(section.getPageSetup());
            StreamedSectionRenderer streamedSectionRenderer = pageSetup.getColumnCount() > 1 && "Across Then Down".equals(pageSetup.getColumnLayout()) ? new AcrossThenDownStreamedSectionRenderer(logicalReport) : new StreamedSectionRenderer(logicalReport);
            streamedSectionRenderer.process(iResourceProvider, section, dataHolder);
            streamedRenderContext.endReport();
            LogicalReport logicalReport2 = logicalReportPageListener.getLogicalReport();
            return logicalReport2;
        }
        finally {
            if (iResourceProvider2 != iResourceProvider) {
                section.setRawReport(iResourceProvider2);
            }
            renderStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogicalReport renderPaged(IResourceProvider iResourceProvider, Section section, DataHolder dataHolder) throws RenderException, DataException {
        RenderStack renderStack = RenderStack.current();
        LogicalReport logicalReport = new LogicalReport();
        LogicalReportPageListener logicalReportPageListener = new LogicalReportPageListener();
        PagedLogicalRenderContext pagedLogicalRenderContext = new PagedLogicalRenderContext(logicalReportPageListener, null);
        IResourceProvider iResourceProvider2 = section.getRawReport();
        if (iResourceProvider2 != iResourceProvider) {
            section.setRawReport(new ResourceProviderStack(iResourceProvider, iResourceProvider2));
            section.loaded();
        }
        renderStack.push(iResourceProvider2, pagedLogicalRenderContext);
        try {
            PagedSectionRenderer pagedSectionRenderer = new PagedSectionRenderer(logicalReport);
            pagedSectionRenderer.setShowPaginatorProgress(false);
            pagedLogicalRenderContext.startReport();
            pagedSectionRenderer.process(iResourceProvider, section, dataHolder);
            pagedLogicalRenderContext.endReport();
            LogicalReport logicalReport2 = logicalReportPageListener.getLogicalReport();
            return logicalReport2;
        }
        finally {
            if (iResourceProvider2 != iResourceProvider) {
                section.setRawReport(iResourceProvider2);
            }
            renderStack.pop();
        }
    }
}

