/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.output.XMLTransformer;
import com.elixirtech.jdom.Content;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.Verifier;
import com.elixirtech.jdom.output.Format;
import com.elixirtech.jdom.output.SAXOutputter;
import com.elixirtech.jdom.output.XMLOutputter;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.Column;
import com.elixirtech.report2.logical.model.Columns;
import com.elixirtech.report2.logical.model.ILogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalElementHolder;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageFooter;
import com.elixirtech.report2.logical.model.PageHeader;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.logical.model.Text;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.Field;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.RawElementHolder;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RenderDetails;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.ContentHandler;

public class XMLPageListener
implements PageListener {
    private Result m_Result;
    private Element m_Root;
    private Element m_Sequence;
    private boolean m_IsPaged;
    private String m_XSLT;

    public XMLPageListener(Result result) {
        this.m_Result = result;
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        RenderDetails renderDetails = pageSource.getRenderDetails();
        if (renderDetails != null) {
            this.m_IsPaged = renderDetails.isSet("Paged");
            this.m_XSLT = renderDetails.isSet("XSLTEnabled") ? renderDetails.getParameterValue("XSLT") : null;
        }
        this.m_Root = new Element("report");
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
        this.m_Sequence = new Element("sequence");
        this.m_Root.addContent(this.m_Sequence);
    }

    @Override
    public void addPage(Page page) throws RenderException {
        PageHeader pageHeader;
        Element element = this.m_Sequence;
        if (this.m_IsPaged) {
            element = new Element("page");
        }
        if ((pageHeader = page.getPageHeader()) != null) {
            this.outputElements(pageHeader, element);
        }
        Iterator<BodyPart> iterator = page.getBody().getBodyPartIterator();
        while (iterator.hasNext()) {
            this.outputElements(iterator.next(), element);
        }
        PageFooter pageFooter = page.getPageFooter();
        if (pageFooter != null) {
            this.outputElements(pageFooter, element);
        }
        if (this.m_IsPaged) {
            this.m_Sequence.addContent(element);
        }
    }

    @Override
    public void endPageSequence(PageSequence pageSequence) throws RenderException {
        this.m_Sequence = null;
    }

    @Override
    public void endReport(PageSource pageSource) throws RenderException {
        String string = "UTF-8";
        boolean bl = true;
        RenderDetails renderDetails = pageSource.getRenderDetails();
        if (renderDetails != null) {
            string = renderDetails.getParameterValue("Encoding", "UTF-8");
            bl = renderDetails.isSet("Indented");
        }
        Document document = new Document(this.m_Root);
        if (StringUtil.notEmpty(this.m_XSLT)) {
            try {
                OutputStream outputStream = this.m_Result.getOutputStream();
                XMLTransformer xMLTransformer = new XMLTransformer(this.m_XSLT, outputStream);
                ContentHandler contentHandler = xMLTransformer.getContentHandler();
                SAXOutputter sAXOutputter = new SAXOutputter(contentHandler);
                sAXOutputter.output(document);
            }
            catch (Exception exception) {
                throw new RenderException("Error writing xml through xslt: " + String.valueOf(exception), exception);
            }
        }
        try {
            OutputStream outputStream = this.m_Result.getOutputStream();
            Format format = null;
            format = !bl ? Format.getCompactFormat() : Format.getPrettyFormat();
            format.setEncoding(string);
            XMLOutputter xMLOutputter = new XMLOutputter(format);
            xMLOutputter.output(document, outputStream);
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new RenderException("Error writing xml: " + String.valueOf(iOException), iOException);
        }
        this.m_Result = null;
        this.m_Root = null;
        this.m_Sequence = null;
    }

    protected void outputElements(LogicalElementHolder logicalElementHolder, Element element) {
        if (logicalElementHolder instanceof Columns) {
            Element element2 = new Element("columns");
            element.addContent(element2);
            for (Column column : ((Columns)logicalElementHolder).getColumnList()) {
                Element element3 = new Element("column");
                element2.addContent(element3);
                for (BodyPart bodyPart : column.getBodyPartList()) {
                    this.outputElements(bodyPart, element3);
                }
            }
        } else {
            String string = ((RawElementHolder)logicalElementHolder.getRaw()).getCaption();
            if (StringUtil.isEmpty(string)) {
                string = logicalElementHolder.getTagName();
            }
            string = string.replace(' ', '_');
            Element element4 = new Element(string);
            element.addContent(element4);
            element = element4;
            ArrayList<LogicalElement> arrayList = new ArrayList<LogicalElement>();
            this.addToList(arrayList, logicalElementHolder.getLogicalElementIterator(), null);
            Collections.sort(arrayList, new YOrdering());
            for (Text text : arrayList) {
                Field field;
                ControlSource controlSource;
                String string2;
                Serializable serializable;
                Object object = text.getId();
                if (StringUtil.isEmpty((String)object) && (serializable = text.getRaw()) instanceof Field && "Field".equals(string2 = (controlSource = (field = (Field)serializable).getControlSource()).getType())) {
                    object = controlSource.getField();
                }
                if (StringUtil.isEmpty((String)object)) {
                    object = "unknown";
                }
                if (Verifier.checkElementName((String)(object = ((String)object).replace(' ', '_'))) != null && Verifier.checkElementName((String)(object = "_" + (String)object)) != null) {
                    object = "invalidName";
                }
                serializable = new Element((String)object);
                ((Element)serializable).addContent(text.getText());
                element.addContent((Content)serializable);
            }
        }
    }

    private void addToList(List<LogicalElement> list, Iterator<LogicalElement> iterator, RawModelElement rawModelElement) {
        while (iterator.hasNext()) {
            LogicalElement logicalElement = iterator.next();
            if (logicalElement instanceof ILogicalElementHolder) {
                RawModelElement rawModelElement2 = logicalElement.getRaw();
                if (rawModelElement2 != null) {
                    rawModelElement = rawModelElement2;
                }
                this.addToList(list, ((ILogicalElementHolder)((Object)logicalElement)).getLogicalElementIterator(), rawModelElement);
                continue;
            }
            if (!(logicalElement instanceof Text)) continue;
            if (rawModelElement != null) {
                if (rawModelElement instanceof RawElement) {
                    logicalElement.setId(((RawElement)rawModelElement).getName());
                } else {
                    logicalElement.setId(((RawElement)rawModelElement).getTagName());
                }
            } else {
                logicalElement.setId("NoId");
            }
            if (!StringUtil.notEmpty(((Text)logicalElement).getText())) continue;
            list.add(logicalElement);
        }
    }

    private static class YOrdering
    implements Comparator<LogicalElement> {
        private YOrdering() {
        }

        @Override
        public int compare(LogicalElement logicalElement, LogicalElement logicalElement2) {
            int n;
            int n2;
            int n3 = logicalElement.getTop();
            if (n3 < (n2 = logicalElement2.getTop())) {
                return -1;
            }
            if (n3 > n2) {
                return 1;
            }
            int n4 = logicalElement.getLeft();
            if (n4 < (n = logicalElement2.getLeft())) {
                return -1;
            }
            if (n4 > n) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof YOrdering;
        }
    }
}

