/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.MimeTypes;
import com.elixirtech.report2.engine.AbstractPipeline;
import com.elixirtech.report2.engine.LogicalRendererEngine;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PagedLogicalRendererEngine;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.engine.Source;
import com.elixirtech.report2.engine.StreamedLogicalRendererEngine;
import com.elixirtech.report2.engine.XMLPageListener;
import com.elixirtech.report2.raw.model.RenderDetails;

public class XMLPipeline
extends AbstractPipeline {
    protected LogicalRendererEngine m_StreamedRenderer;
    protected LogicalRendererEngine m_PagedRenderer;

    public XMLPipeline() {
        this.initFeature("DefaultFileExtension", ".xml");
        this.m_StreamedRenderer = new StreamedLogicalRendererEngine();
        this.m_PagedRenderer = new PagedLogicalRendererEngine();
    }

    @Override
    public LogicalRendererEngine getLogicalRendererEngine(Source source) {
        RenderDetails renderDetails = source.getRawReport().getRenderDetails(MimeTypes.XML().value());
        if (this.isPaged(renderDetails)) {
            return this.m_PagedRenderer;
        }
        return this.m_StreamedRenderer;
    }

    @Override
    public PageListener getPageListener(Result result) {
        return new XMLPageListener(result);
    }

    @Override
    public void dispose() {
        this.m_StreamedRenderer = null;
        this.m_PagedRenderer = null;
        super.dispose();
    }

    public boolean isPaged(RenderDetails renderDetails) {
        if (renderDetails == null) {
            return false;
        }
        return "Yes".equals(renderDetails.getParameterValue("Paged", "Yes"));
    }
}

