/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine.pl;

import com.elixirtech.arch.LoggingHelper;
import com.elixirtech.arch.job.JobLogging$;
import com.elixirtech.arch.job.JobPageCount$;
import com.elixirtech.arch.logging.SLF4J;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import java.io.Serializable;
import org.slf4j.Logger;
import scala.Function0;
import scala.Int$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class AuditPageListener
implements PageListener,
SLF4J,
LoggingHelper {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AuditPageListener.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    private final PageListener next;
    private int pageCount;
    private final String logCat;

    public AuditPageListener(PageListener next, Result result) {
        this.next = next;
        this.pageCount = 0;
        this.logCat = this.logCategory();
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggingHelper.logger$((LoggingHelper)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public void startReport(PageSource psrc) {
        JobLogging$.MODULE$.info(this.logCat, (Function0<String>)((Function0 & Serializable)AuditPageListener::startReport$$anonfun$1));
        this.next.startReport(psrc);
    }

    @Override
    public void startPageSequence(PageSequence ps) {
        if (this.pageCount == 0) {
            JobLogging$.MODULE$.info(this.logCat, (Function0<String>)((Function0 & Serializable)AuditPageListener::startPageSequence$$anonfun$1));
        }
        this.next.startPageSequence(ps);
    }

    @Override
    public void addPage(Page p) {
        if (this.outputPageRenderingInfo()) {
            JobLogging$.MODULE$.info(this.logCat, (Function0<String>)((Function0 & Serializable)this::addPage$$anonfun$1));
        }
        if (Thread.currentThread().isInterrupted()) {
            JobLogging$.MODULE$.warn(this.logCat, (Function0<String>)((Function0 & Serializable)AuditPageListener::addPage$$anonfun$2));
            return;
        }
        this.next.addPage(p);
        ++this.pageCount;
    }

    @Override
    public void endPageSequence(PageSequence ps) {
        this.next.endPageSequence(ps);
    }

    @Override
    public void endReport(PageSource psrc) {
        JobLogging$.MODULE$.info(this.logCat, (Function0<String>)((Function0 & Serializable)AuditPageListener::endReport$$anonfun$1));
        this.next.endReport(psrc);
        JobLogging$.MODULE$.info(this.logCat, (Function0<String>)((Function0 & Serializable)AuditPageListener::endReport$$anonfun$2));
        JobLogging$.MODULE$.add(JobPageCount$.MODULE$.apply(Int$.MODULE$.int2long(this.pageCount), JobPageCount$.MODULE$.$lessinit$greater$default$2()));
    }

    private boolean outputPageRenderingInfo() {
        int test = this.pageCount + 1;
        if (test <= 10) {
            return true;
        }
        if (test <= 100 && test % 10 == 0) {
            return true;
        }
        if (test <= 1000 && test % 100 == 0) {
            return true;
        }
        if (test <= 10000 && test % 1000 == 0) {
            return true;
        }
        return test <= 100000 && test % 10000 == 0;
    }

    private static final String startReport$$anonfun$1() {
        return "Report Started";
    }

    private static final String startPageSequence$$anonfun$1() {
        return "Rendering Started";
    }

    private final String addPage$$anonfun$1() {
        return "Rendering Page " + (this.pageCount + 1);
    }

    private static final String addPage$$anonfun$2() {
        return "Interrupt detected in addPage";
    }

    private static final String endReport$$anonfun$1() {
        return "Rendering Complete";
    }

    private static final String endReport$$anonfun$2() {
        return "Report Complete";
    }
}

