/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine.pl;

import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import java.util.ArrayList;
import java.util.List;

public class PageCountListener
implements PageListener {
    private PageListener m_Next;
    private List<PS> m_PageSequences = new ArrayList<PS>();
    private List<Page> m_Pages = new ArrayList<Page>();
    private PS m_Current;

    public PageCountListener(PageListener pageListener) {
        this.m_Next = pageListener;
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        this.m_Next.startReport(pageSource);
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
        if (pageSequence.isResetPageCount()) {
            this.flushPriorPages();
        }
        this.m_Current = new PS(pageSequence);
        this.m_PageSequences.add(this.m_Current);
    }

    @Override
    public void addPage(Page page) throws RenderException {
        this.m_Current.pages.add(page);
        this.m_Pages.add(page);
    }

    @Override
    public void endPageSequence(PageSequence pageSequence) throws RenderException {
        this.m_Current = null;
    }

    @Override
    public void endReport(PageSource pageSource) throws RenderException {
        this.flushPriorPages();
        this.m_Next.endReport(pageSource);
        this.m_Next = null;
        this.m_Current = null;
        this.m_Pages = null;
        this.m_PageSequences = null;
    }

    private void flushPriorPages() {
        this.setPageCounts();
        for (PS pS : this.m_PageSequences) {
            this.m_Next.startPageSequence(pS.ps);
            for (Page page : pS.pages) {
                this.m_Next.addPage(page);
            }
            this.m_Next.endPageSequence(pS.ps);
        }
        this.m_PageSequences.clear();
    }

    private void setPageCounts() {
        int n = 1;
        int n2 = this.m_Pages.size();
        for (Page object : this.m_Pages) {
            object.setPageNumber(n++);
            object.setPageCount(n2);
        }
        this.m_Pages.clear();
        for (PS pS : this.m_PageSequences) {
            pS.ps.setCachedPageCount(n2);
        }
    }

    private static class PS {
        public PageSequence ps;
        public List<Page> pages = new ArrayList<Page>();

        public PS(PageSequence pageSequence) {
            this.ps = pageSequence;
        }
    }
}

