/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.html;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.output.XMLOutputter;
import com.elixirtech.report2.html.Style;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HTMLElement {
    private final String m_Name;
    private HashMap<String, String> m_Attributes;
    private List<Object> m_Children;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(HTMLElement.class);

    public HTMLElement(String string) {
        this.m_Name = string;
    }

    public String getName() {
        return this.m_Name;
    }

    public Map<String, String> getAttributes() {
        if (this.m_Attributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.m_Attributes);
    }

    public Iterator<Object> getChildren() {
        if (this.m_Children == null) {
            return Collections.emptyList().iterator();
        }
        return Collections.unmodifiableList(this.m_Children).iterator();
    }

    public void addAttribute(String string, String string2) {
        if (this.m_Attributes == null) {
            this.m_Attributes = new HashMap();
        }
        this.m_Attributes.put(string, string2);
    }

    public String getAttribute(String string) {
        if (this.m_Attributes == null) {
            return null;
        }
        return this.m_Attributes.get(string);
    }

    public HTMLElement addChild(String string) {
        return this.addChild(new HTMLElement(string));
    }

    public HTMLElement addChild(HTMLElement hTMLElement) {
        if (this.m_Children == null) {
            this.m_Children = new ArrayList<Object>();
        }
        this.m_Children.add(hTMLElement);
        return hTMLElement;
    }

    public void addStyle(Style style) {
        this.addAttribute("style", style.toString());
    }

    public void addText(String string) {
        if (this.m_Children == null) {
            this.m_Children = new ArrayList<Object>();
        }
        this.m_Children.add(this.normalize(string));
    }

    public void addRawText(String string) {
        if (this.m_Children == null) {
            this.m_Children = new ArrayList<Object>();
        }
        this.m_Children.add(string);
    }

    public void addElement(Element element) {
        StringWriter stringWriter = new StringWriter();
        XMLOutputter xMLOutputter = new XMLOutputter();
        try {
            xMLOutputter.output(element, (Writer)stringWriter);
            if (this.m_Children == null) {
                this.m_Children = new ArrayList<Object>();
            }
            this.m_Children.add(stringWriter.toString());
        }
        catch (IOException iOException) {
            m_Log.warn((Object)("Can't add element " + element.getName()));
        }
    }

    protected String normalize(String string) {
        return StringUtil.findAndReplace(string, '<', "&lt;");
    }
}

