/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.html;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.output.Format;
import com.elixirtech.jdom.output.XMLOutputter;
import com.elixirtech.report2.html.HTMLElement;
import com.elixirtech.report2.html.HTMLGenerator;
import com.elixirtech.report2.html.HTMLPage;
import com.elixirtech.report2.logical.model.LogicalReport;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class TOCBuilder {
    private Element m_Root = new Element("metadata");
    private Element m_TOC;
    private Element m_Pages;
    private Element m_CurrentTOC;
    private HTMLPage m_CurrentPage;
    private int m_Depth;
    private HTMLGenerator m_generator;

    public TOCBuilder(LogicalReport logicalReport, HTMLGenerator hTMLGenerator) {
        TOCBuilder.setAttribute(this.m_Root, "title", logicalReport.getCaption());
        this.m_TOC = new Element("toc");
        this.m_Root.addContent(this.m_TOC);
        this.m_Pages = new Element("pages");
        this.m_Root.addContent(this.m_Pages);
        this.m_CurrentTOC = this.m_TOC;
        this.m_generator = hTMLGenerator;
    }

    public void addPage(HTMLPage hTMLPage) {
        this.m_CurrentPage = hTMLPage;
        Element element = new Element("page");
        TOCBuilder.setAttribute(element, "name", hTMLPage.getFilename());
        TOCBuilder.setAttribute(element, "link", hTMLPage.getLinkname());
        this.m_Pages.addContent(element);
    }

    public void pushTOC(String string, int n, String string2) {
        while (this.m_Depth > n) {
            this.popTOC();
        }
        Element element = new Element("entry");
        TOCBuilder.setAttribute(element, "page", this.m_CurrentPage.getFilename());
        TOCBuilder.setAttribute(element, "id", string);
        TOCBuilder.setAttribute(element, "title", string2);
        this.m_CurrentTOC.addContent(element);
        this.m_CurrentTOC = element;
        ++this.m_Depth;
    }

    public void popTOC() {
        this.m_CurrentTOC = (Element)this.m_CurrentTOC.getParent();
        --this.m_Depth;
    }

    private static void setAttribute(Element element, String string, String string2) {
        if (StringUtil.notEmpty(string2)) {
            element.setAttribute(string, string2);
        }
    }

    public void render(ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry("metadata.xml");
        zipOutputStream.putNextEntry(zipEntry);
        this.writeMetadata(zipOutputStream);
        zipOutputStream.closeEntry();
    }

    public void writeMetadata(OutputStream outputStream) throws IOException {
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getCompactFormat());
        xMLOutputter.output(new Document(this.m_Root), outputStream);
    }

    public String getIndexContents() throws IOException {
        if (!this.m_generator.isTreeMode()) {
            Object object;
            Object object2;
            Object object3;
            HTMLElement hTMLElement = new HTMLElement("body");
            HTMLElement hTMLElement2 = hTMLElement.addChild("h3");
            hTMLElement2.addText(this.m_Root.getAttributeValue("title"));
            if (this.hasTOC()) {
                object3 = hTMLElement.addChild("a");
                ((HTMLElement)object3).addAttribute("href", "javascript:toggleToc()");
                ((HTMLElement)object3).addText("Table of Contents");
                hTMLElement.addChild("p");
            }
            object3 = this.m_Pages.getChildren("page").iterator();
            int n = 1;
            while (object3.hasNext()) {
                object2 = (Element)object3.next();
                object = hTMLElement.addChild("a");
                ((HTMLElement)object).addAttribute("href", "javascript:showPage(" + n++ + ");");
                ((HTMLElement)object).addText(((Element)object2).getAttributeValue("link"));
                hTMLElement.addChild("br");
            }
            object2 = new StringWriter();
            object = hTMLElement.getChildren();
            while (object.hasNext()) {
                HTMLElement hTMLElement3 = (HTMLElement)object.next();
                this.m_generator.getOutputter().output(hTMLElement3, (Writer)object2);
            }
            return ((StringWriter)object2).toString();
        }
        return null;
    }

    public String getTOCContents() throws IOException {
        if (!this.m_generator.isTreeMode() && this.hasTOC()) {
            HTMLElement hTMLElement = new HTMLElement("body");
            HTMLElement hTMLElement2 = hTMLElement.addChild("h3");
            hTMLElement2.addText(this.m_Root.getAttributeValue("title"));
            HTMLElement hTMLElement3 = hTMLElement.addChild("a");
            hTMLElement3.addAttribute("href", "javascript:toggleToc()");
            hTMLElement3.addText("Page Index");
            hTMLElement.addChild("p");
            for (Element object2 : this.m_TOC.getChildren("entry")) {
                this.writeTOC(hTMLElement, object2, 0);
            }
            StringWriter stringWriter = new StringWriter();
            Iterator<Object> iterator = hTMLElement.getChildren();
            while (iterator.hasNext()) {
                HTMLElement hTMLElement4 = (HTMLElement)iterator.next();
                this.m_generator.getOutputter().output(hTMLElement4, (Writer)stringWriter);
            }
            return stringWriter.toString();
        }
        return null;
    }

    public int getPageCount() {
        return this.m_Pages.getChildren("page").size();
    }

    protected void writeTOC(HTMLElement hTMLElement, Element element, int n) {
        String string = element.getAttributeValue("page");
        String string2 = element.getAttributeValue("id");
        String string3 = element.getAttributeValue("title");
        if (StringUtil.notEmpty(string3)) {
            HTMLElement hTMLElement2 = hTMLElement.addChild("span");
            StringBuilder serializable = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                serializable.append("-");
            }
            hTMLElement2.addText(serializable.toString());
            HTMLElement hTMLElement3 = hTMLElement.addChild("a");
            hTMLElement3.addAttribute("href", "javascript:showAnchor('" + string + "','" + string2 + "');");
            hTMLElement3.addText(string3);
            hTMLElement.addChild("br");
        }
        for (Element element2 : element.getChildren("entry")) {
            this.writeTOC(hTMLElement, element2, n + 1);
        }
    }

    protected boolean hasTOC() {
        return this.m_TOC.getChildren().size() > 0;
    }
}

